/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.Closeable;
import java.net.BindException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopException;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.EsHadoopNoNodesLeftException;
import org.elasticsearch.hadoop.rest.EsHadoopTransportException;
import org.elasticsearch.hadoop.rest.Request;
import org.elasticsearch.hadoop.rest.Response;
import org.elasticsearch.hadoop.rest.SimpleRequest;
import org.elasticsearch.hadoop.rest.Transport;
import org.elasticsearch.hadoop.rest.TransportFactory;
import org.elasticsearch.hadoop.rest.commonshttp.CommonsHttpTransportFactory;
import org.elasticsearch.hadoop.rest.pooling.PooledTransportManager;
import org.elasticsearch.hadoop.rest.stats.Stats;
import org.elasticsearch.hadoop.rest.stats.StatsAware;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.ByteSequence;
import org.elasticsearch.hadoop.util.SettingsUtils;

public class NetworkClient
implements StatsAware,
Closeable {
    private static Log log = LogFactory.getLog(NetworkClient.class);
    private final Settings settings;
    private final List<String> nodes;
    private final Map<String, Throwable> failedNodes = new LinkedHashMap<String, Throwable>();
    private TransportFactory transportFactory;
    private Transport currentTransport;
    private String currentNode;
    private int nextClient = 0;
    private final Stats stats = new Stats();

    public NetworkClient(Settings settings) {
        this(settings, !SettingsUtils.hasJobTransportPoolingKey(settings) ? new CommonsHttpTransportFactory() : PooledTransportManager.getTransportFactory(settings));
    }

    public NetworkClient(Settings settings, TransportFactory transportFactory) {
        this.settings = settings.copy();
        this.nodes = SettingsUtils.discoveredOrDeclaredNodes(settings);
        this.transportFactory = transportFactory;
        Collections.shuffle(this.nodes);
        if (SettingsUtils.hasPinnedNode(settings)) {
            String pinnedNode = SettingsUtils.getPinnedNode(settings);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Opening (pinned) network client to " + pinnedNode));
            }
            this.nodes.remove(pinnedNode);
            this.nodes.add(0, pinnedNode);
        }
        this.selectNextNode();
        Assert.notNull(this.currentTransport, "no node information provided");
    }

    private boolean selectNextNode() {
        if (this.nextClient >= this.nodes.size()) {
            return false;
        }
        if (this.currentTransport != null) {
            ++this.stats.nodeRetries;
        }
        this.closeTransport();
        this.currentNode = this.nodes.get(this.nextClient++);
        SettingsUtils.pinNode(this.settings, this.currentNode);
        this.currentTransport = this.transportFactory.create(this.settings, this.currentNode);
        return true;
    }

    public Response execute(Request request) {
        boolean newNode;
        Response response = null;
        do {
            SimpleRequest routedRequest = new SimpleRequest(request.method(), null, request.path(), request.params(), request.body());
            newNode = false;
            try {
                response = this.currentTransport.execute(routedRequest);
                ByteSequence body = routedRequest.body();
                if (body == null) continue;
                this.stats.bytesSent += (long)body.length();
            }
            catch (Exception ex) {
                if (ex instanceof EsHadoopIllegalStateException) {
                    throw (EsHadoopException)ex;
                }
                if (ex instanceof SSLException) {
                    throw new EsHadoopTransportException(ex);
                }
                if (ex instanceof BindException) {
                    throw new EsHadoopTransportException(ex);
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Caught exception while performing request [%s][%s] - falling back to the next node in line...", this.currentNode, request.path()), (Throwable)ex);
                }
                String failed = this.currentNode;
                this.failedNodes.put(failed, ex);
                newNode = this.selectNextNode();
                log.error((Object)String.format("Node [%s] failed (%s); " + (newNode ? "selected next node [" + this.currentNode + "]" : "no other nodes left - aborting..."), failed, ex.getMessage()));
                if (newNode) continue;
                throw new EsHadoopNoNodesLeftException(this.failedNodes);
            }
        } while (newNode);
        return response;
    }

    @Override
    public void close() {
        this.closeTransport();
    }

    private void closeTransport() {
        if (this.currentTransport != null) {
            this.currentTransport.close();
            this.stats.aggregate(this.currentTransport.stats());
            this.currentTransport = null;
        }
    }

    @Override
    public Stats stats() {
        Stats copy = new Stats(this.stats);
        if (this.currentTransport != null) {
            copy.aggregate(this.currentTransport.stats());
        }
        return copy;
    }

    Stats transportStats() {
        return this.currentTransport.stats();
    }

    public String currentNode() {
        return this.currentNode;
    }
}

