/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.SettingsAware;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;
import org.elasticsearch.hadoop.serialization.field.FieldFilter;
import org.elasticsearch.hadoop.util.StringUtils;

public abstract class FilteringValueWriter<T>
implements ValueWriter<T>,
SettingsAware {
    private List<FieldFilter.NumberedInclude> includes;
    private List<String> excludes;

    @Override
    public void setSettings(Settings settings) {
        List<String> includeAsStrings = StringUtils.tokenize(settings.getMappingIncludes());
        this.includes = includeAsStrings.isEmpty() ? Collections.emptyList() : new ArrayList(includeAsStrings.size());
        for (String include : includeAsStrings) {
            this.includes.add(new FieldFilter.NumberedInclude(include));
        }
        this.excludes = StringUtils.tokenize(settings.getMappingExcludes());
    }

    protected boolean shouldKeep(String parentField, String name) {
        name = StringUtils.hasText(parentField) ? parentField + "." + name : name;
        return FieldFilter.filter((String)name, this.includes, this.excludes).matched;
    }
}

