/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.commonshttp.auth.spnego;

import java.io.Closeable;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.rest.EsHadoopTransportException;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.StringUtils;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SpnegoNegotiator
implements Closeable {
    private static final String SPNEGO_OID = "1.3.6.1.5.5.2";
    private final GSSManager gssManager = GSSManager.getInstance();
    private final Oid spnegoOID = new Oid("1.3.6.1.5.5.2");
    private final GSSName servicePrincipalName;
    private final GSSCredential userCredential;
    private GSSContext gssContext = null;
    private byte[] token = null;

    public SpnegoNegotiator(String userPrincipal, String serverPrincipal) throws GSSException {
        GSSName userPrincipalName = this.gssManager.createName(userPrincipal, GSSName.NT_USER_NAME, this.spnegoOID);
        this.servicePrincipalName = this.gssManager.createName(serverPrincipal, GSSName.NT_USER_NAME);
        this.userCredential = this.gssManager.createCredential(userPrincipalName, 0, this.spnegoOID, 1);
    }

    public void setTokenData(String data) {
        if (this.gssContext == null) {
            throw new EsHadoopIllegalStateException("GSS Context not yet initialized. Client must be the initiator.");
        }
        this.token = Base64.decodeBase64((String)data);
    }

    public String send(String data) throws GSSException {
        this.setTokenData(data);
        return this.send();
    }

    public String send() throws GSSException {
        byte[] sendData;
        if (this.gssContext == null) {
            Assert.isTrue(this.token == null, "GSS Context not yet initialized. Client must be the initiator.");
            this.gssContext = this.gssManager.createContext(this.servicePrincipalName, this.spnegoOID, this.userCredential, 0);
            sendData = this.gssContext.initSecContext(new byte[0], 0, 0);
        } else if (this.token != null) {
            sendData = this.gssContext.initSecContext(this.token, 0, this.token.length);
            this.token = null;
        } else {
            throw new EsHadoopTransportException("Missing required negotiation token");
        }
        if (sendData == null) {
            return null;
        }
        return new String(Base64.encodeBase64((byte[])sendData), StringUtils.UTF_8);
    }

    public boolean established() {
        return this.gssContext != null && this.gssContext.isEstablished();
    }

    @Override
    public void close() throws IOException {
        if (this.gssContext != null) {
            try {
                this.gssContext.dispose();
            }
            catch (GSSException e) {
                throw new IOException("Could not dispose of GSSContext", e);
            }
        }
    }
}

