/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.sql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.rest.RestRepository;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.serialization.dto.mapping.Field;
import org.elasticsearch.hadoop.serialization.dto.mapping.GeoField;
import org.elasticsearch.hadoop.serialization.dto.mapping.GeoPointType;
import org.elasticsearch.hadoop.serialization.dto.mapping.GeoShapeType;
import org.elasticsearch.hadoop.serialization.dto.mapping.Mapping;
import org.elasticsearch.hadoop.serialization.dto.mapping.MappingSet;
import org.elasticsearch.hadoop.serialization.dto.mapping.MappingUtils;
import org.elasticsearch.hadoop.serialization.field.FieldFilter;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.SettingsUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.spark.sql.SchemaUtils;
import org.elasticsearch.spark.sql.Utils;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.LinkedHashMap;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class SchemaUtils$ {
    public static SchemaUtils$ MODULE$;

    static {
        new SchemaUtils$();
    }

    public SchemaUtils.Schema discoverMapping(Settings cfg) {
        Tuple2<Mapping, Map<String, GeoField>> tuple2 = this.discoverMappingAndGeoFields(cfg);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Mapping mapping = (Mapping)tuple2._1();
        Map geoInfo = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)mapping, (Object)geoInfo);
        Tuple2 tuple23 = tuple22;
        Mapping mapping2 = (Mapping)tuple23._1();
        Map geoInfo2 = (Map)tuple23._2();
        StructType struct = this.convertToStruct(mapping2, geoInfo2, cfg);
        return new SchemaUtils.Schema(mapping2, struct);
    }

    public Tuple2<Mapping, Map<String, GeoField>> discoverMappingAndGeoFields(Settings cfg) {
        Tuple2 tuple2;
        block6: {
            InitializationUtils.validateSettings(cfg);
            InitializationUtils.discoverClusterInfo(cfg, Utils.LOGGER);
            try (RestRepository repo = new RestRepository(cfg);){
                if (repo.resourceExists(true)) {
                    MappingSet mappingSet = repo.getMappings();
                    if (mappingSet == null || mappingSet.isEmpty()) {
                        throw new EsHadoopIllegalArgumentException(new StringBuilder(65).append("Cannot find mapping for ").append(cfg.getResourceRead()).append(" - one is required before using Spark SQL").toString());
                    }
                    Mapping mapping = mappingSet.getResolvedView();
                    mapping = MappingUtils.filterMapping(mapping, cfg);
                    Map<String, GeoField> geoInfo = repo.sampleGeoFields(mapping);
                    if (StringUtils.hasText(cfg.getReadFieldInclude()) || StringUtils.hasText(cfg.getReadFieldExclude())) {
                        cfg.setProperty("es.internal.mr.target.fields", StringUtils.concatenate(mapping.flatten().keySet(), ","));
                    }
                    tuple2 = new Tuple2((Object)mapping, geoInfo);
                    break block6;
                }
                throw new EsHadoopIllegalArgumentException(new StringBuilder(65).append("Cannot find mapping for ").append(cfg.getResourceRead()).append(" - one is required before using Spark SQL").toString());
            }
        }
        return tuple2;
    }

    public StructType convertToStruct(Mapping mapping, Map<String, GeoField> geoInfo, Settings cfg) {
        StructField[] fields;
        block0: {
            List<FieldFilter.NumberedInclude> arrayIncludes = SettingsUtils.getFieldArrayFilterInclude(cfg);
            List<String> arrayExcludes = StringUtils.tokenize(cfg.getReadFieldAsArrayExclude());
            fields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapping.getFields())).map((Function1 & Serializable & scala.Serializable)fl -> MODULE$.convertField((Field)fl, geoInfo, null, arrayIncludes, arrayExcludes, cfg), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
            if (!cfg.getReadMetadata()) break block0;
            StructField metadataMap = DataTypes.createStructField((String)cfg.getReadMetadataField(), (DataType)DataTypes.createMapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, (boolean)true), (boolean)true);
            fields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).$colon$plus((Object)metadataMap, ClassTag$.MODULE$.apply(StructField.class));
        }
        return DataTypes.createStructType((StructField[])fields);
    }

    private StructType convertToStruct(Field field, Map<String, GeoField> geoInfo, String parentName, List<FieldFilter.NumberedInclude> arrayIncludes, List<String> arrayExcludes, Settings cfg) {
        return DataTypes.createStructType((StructField[])((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])field.properties())).map((Function1 & Serializable & scala.Serializable)fl -> MODULE$.convertField((Field)fl, geoInfo, parentName, arrayIncludes, arrayExcludes, cfg), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))));
    }

    private StructField convertField(Field field, Map<String, GeoField> geoInfo, String parentName, List<FieldFilter.NumberedInclude> arrayIncludes, List<String> arrayExcludes, Settings cfg) {
        ObjectRef dataType;
        block69: {
            NullType$ nullType$;
            String absoluteName = parentName != null ? new StringBuilder(1).append(parentName).append(".").append(field.name()).toString() : field.name();
            FieldFilter.Result matched = FieldFilter.filter(absoluteName, arrayIncludes, arrayExcludes, false);
            boolean createArray = !arrayIncludes.isEmpty() && matched.matched;
            FieldType fieldType = Utils.extractType(field);
            if (((Object)((Object)FieldType.NULL)).equals((Object)fieldType)) {
                nullType$ = NullType$.MODULE$;
            } else if (((Object)((Object)FieldType.BINARY)).equals((Object)fieldType)) {
                nullType$ = BinaryType$.MODULE$;
            } else if (((Object)((Object)FieldType.BOOLEAN)).equals((Object)fieldType)) {
                nullType$ = BooleanType$.MODULE$;
            } else if (((Object)((Object)FieldType.BYTE)).equals((Object)fieldType)) {
                nullType$ = ByteType$.MODULE$;
            } else if (((Object)((Object)FieldType.SHORT)).equals((Object)fieldType)) {
                nullType$ = ShortType$.MODULE$;
            } else if (((Object)((Object)FieldType.INTEGER)).equals((Object)fieldType)) {
                nullType$ = IntegerType$.MODULE$;
            } else if (((Object)((Object)FieldType.LONG)).equals((Object)fieldType)) {
                nullType$ = LongType$.MODULE$;
            } else if (((Object)((Object)FieldType.FLOAT)).equals((Object)fieldType)) {
                nullType$ = FloatType$.MODULE$;
            } else if (((Object)((Object)FieldType.DOUBLE)).equals((Object)fieldType)) {
                nullType$ = DoubleType$.MODULE$;
            } else if (((Object)((Object)FieldType.HALF_FLOAT)).equals((Object)fieldType)) {
                nullType$ = FloatType$.MODULE$;
            } else if (((Object)((Object)FieldType.SCALED_FLOAT)).equals((Object)fieldType)) {
                nullType$ = DoubleType$.MODULE$;
            } else if (((Object)((Object)FieldType.STRING)).equals((Object)fieldType)) {
                nullType$ = StringType$.MODULE$;
            } else if (((Object)((Object)FieldType.TEXT)).equals((Object)fieldType)) {
                nullType$ = StringType$.MODULE$;
            } else if (((Object)((Object)FieldType.KEYWORD)).equals((Object)fieldType)) {
                nullType$ = StringType$.MODULE$;
            } else if (((Object)((Object)FieldType.DATE)).equals((Object)fieldType)) {
                nullType$ = cfg.getMappingDateRich() ? TimestampType$.MODULE$ : StringType$.MODULE$;
            } else if (((Object)((Object)FieldType.DATE_NANOS)).equals((Object)fieldType)) {
                nullType$ = cfg.getMappingDateRich() ? TimestampType$.MODULE$ : StringType$.MODULE$;
            } else if (((Object)((Object)FieldType.OBJECT)).equals((Object)fieldType)) {
                nullType$ = this.convertToStruct(field, geoInfo, absoluteName, arrayIncludes, arrayExcludes, cfg);
            } else if (((Object)((Object)FieldType.NESTED)).equals((Object)fieldType)) {
                nullType$ = DataTypes.createArrayType((DataType)this.convertToStruct(field, geoInfo, absoluteName, arrayIncludes, arrayExcludes, cfg));
            } else if (((Object)((Object)FieldType.JOIN)).equals((Object)fieldType)) {
                nullType$ = this.convertToStruct(field, geoInfo, absoluteName, arrayIncludes, arrayExcludes, cfg);
            } else if (((Object)((Object)FieldType.GEO_POINT)).equals((Object)fieldType)) {
                ArrayType arrayType;
                GeoField geoField = geoInfo.get(absoluteName);
                if (GeoPointType.LON_LAT_ARRAY.equals(geoField)) {
                    arrayType = DataTypes.createArrayType((DataType)DoubleType$.MODULE$);
                } else if (GeoPointType.GEOHASH.equals(geoField)) {
                    arrayType = StringType$.MODULE$;
                } else if (GeoPointType.LAT_LON_STRING.equals(geoField)) {
                    arrayType = StringType$.MODULE$;
                } else if (GeoPointType.LAT_LON_OBJECT.equals(geoField)) {
                    StructField lat = DataTypes.createStructField((String)"lat", (DataType)DoubleType$.MODULE$, (boolean)true);
                    StructField lon = DataTypes.createStructField((String)"lon", (DataType)DoubleType$.MODULE$, (boolean)true);
                    arrayType = DataTypes.createStructType((StructField[])((StructField[])((Object[])new StructField[]{lat, lon})));
                } else {
                    throw new MatchError((Object)geoField);
                }
                ArrayType geoPoint = arrayType;
                if (Utils.LOGGER.isDebugEnabled()) {
                    Utils.LOGGER.debug((Object)new StringBuilder(44).append("Detected field [").append(absoluteName).append("] as a GeoPoint with format ").append(geoPoint.simpleString()).toString());
                }
                nullType$ = geoPoint;
            } else if (((Object)((Object)FieldType.GEO_SHAPE)).equals((Object)fieldType)) {
                boolean bl;
                ArrayList<StructField> fields = new ArrayList<StructField>();
                fields.add(DataTypes.createStructField((String)"type", (DataType)StringType$.MODULE$, (boolean)true));
                String COORD = "coordinates";
                GeoField geoField = geoInfo.get(absoluteName);
                if (GeoShapeType.POINT.equals(geoField)) {
                    bl = fields.add(DataTypes.createStructField((String)COORD, (DataType)DataTypes.createArrayType((DataType)DoubleType$.MODULE$), (boolean)true));
                } else if (GeoShapeType.LINE_STRING.equals(geoField)) {
                    bl = fields.add(DataTypes.createStructField((String)COORD, (DataType)this.createNestedArray((DataType)DoubleType$.MODULE$, 2), (boolean)true));
                } else if (GeoShapeType.POLYGON.equals(geoField)) {
                    fields.add(DataTypes.createStructField((String)COORD, (DataType)this.createNestedArray((DataType)DoubleType$.MODULE$, 3), (boolean)true));
                    bl = fields.add(DataTypes.createStructField((String)"orientation", (DataType)StringType$.MODULE$, (boolean)true));
                } else if (GeoShapeType.MULTI_POINT.equals(geoField)) {
                    bl = fields.add(DataTypes.createStructField((String)COORD, (DataType)this.createNestedArray((DataType)DoubleType$.MODULE$, 2), (boolean)true));
                } else if (GeoShapeType.MULTI_LINE_STRING.equals(geoField)) {
                    bl = fields.add(DataTypes.createStructField((String)COORD, (DataType)this.createNestedArray((DataType)DoubleType$.MODULE$, 3), (boolean)true));
                } else if (GeoShapeType.MULTI_POLYGON.equals(geoField)) {
                    bl = fields.add(DataTypes.createStructField((String)COORD, (DataType)this.createNestedArray((DataType)DoubleType$.MODULE$, 4), (boolean)true));
                } else {
                    if (GeoShapeType.GEOMETRY_COLLECTION.equals(geoField)) {
                        throw new EsHadoopIllegalArgumentException(new StringBuilder(23).append("Geoshape ").append(geoInfo).append(" not supported").toString());
                    }
                    if (GeoShapeType.ENVELOPE.equals(geoField)) {
                        bl = fields.add(DataTypes.createStructField((String)COORD, (DataType)this.createNestedArray((DataType)DoubleType$.MODULE$, 2), (boolean)true));
                    } else if (GeoShapeType.CIRCLE.equals(geoField)) {
                        fields.add(DataTypes.createStructField((String)COORD, (DataType)DataTypes.createArrayType((DataType)DoubleType$.MODULE$), (boolean)true));
                        bl = fields.add(DataTypes.createStructField((String)"radius", (DataType)StringType$.MODULE$, (boolean)true));
                    } else {
                        throw new MatchError((Object)geoField);
                    }
                }
                StructType geoShape = DataTypes.createStructType(fields);
                if (Utils.LOGGER.isDebugEnabled()) {
                    Utils.LOGGER.debug((Object)new StringBuilder(44).append("Detected field [").append(absoluteName).append("] as a GeoShape with format ").append(geoShape.simpleString()).toString());
                }
                nullType$ = geoShape;
            } else {
                nullType$ = StringType$.MODULE$;
            }
            dataType = ObjectRef.create((Object)nullType$);
            if (!createArray) break block69;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), matched.depth).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                dataType$1.elem = DataTypes.createArrayType((DataType)((DataType)dataType$1.elem));
            });
        }
        return DataTypes.createStructField((String)field.name(), (DataType)((DataType)dataType.elem), (boolean)true);
    }

    private DataType createNestedArray(DataType elementType, int depth) {
        ObjectRef array = ObjectRef.create((Object)elementType);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), depth).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            array$1.elem = DataTypes.createArrayType((DataType)((DataType)array$1.elem));
        });
        return (DataType)array.elem;
    }

    public void setRowInfo(Settings settings, StructType struct) {
        Tuple2<Properties, Properties> rowInfo = this.detectRowInfo(settings, struct);
        settings.setProperty("es.internal.spark.sql.row.order", IOUtils.propsToString((Properties)rowInfo._1()));
        settings.setProperty("es.internal.spark.sql.row.arrays", IOUtils.propsToString((Properties)rowInfo._2()));
    }

    public Tuple2<LinkedHashMap<String, Seq<String>>, LinkedHashSet<String>> getRowInfo(Settings settings) {
        String rowOrderString = settings.getProperty("es.internal.spark.sql.row.order");
        Assert.hasText(rowOrderString, "no schema/row order detected...");
        Properties rowOrderProps = IOUtils.propsFromString(rowOrderString);
        String rowArrayString = settings.getProperty("es.internal.spark.sql.row.arrays");
        Properties rowArrayProps = StringUtils.hasText(rowArrayString) ? IOUtils.propsFromString(rowArrayString) : new Properties();
        LinkedHashMap order = new LinkedHashMap();
        ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(rowOrderProps).asScala()).foreach((Function1 & Serializable & scala.Serializable)prop -> {
            Buffer value = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(StringUtils.tokenize((String)prop._2())).asScala();
            return !value.isEmpty() ? order.put(prop._1(), (Object)new ArrayBuffer().$plus$plus$eq((TraversableOnce)value)) : BoxedUnit.UNIT;
        });
        LinkedHashSet needToBeArray = new LinkedHashSet();
        ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(rowArrayProps).asScala()).foreach((Function1 & Serializable & scala.Serializable)prop -> BoxesRunTime.boxToBoolean((boolean)needToBeArray.add(prop._1())));
        return new Tuple2((Object)order, needToBeArray);
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Properties, Properties> detectRowInfo(Settings settings, StructType struct) {
        void var3_3;
        Tuple2 rowInfo = new Tuple2((Object)new Properties(), (Object)new Properties());
        this.doDetectInfo((Tuple2<Properties, Properties>)rowInfo, "_", (DataType)struct);
        String requiredFields = settings.getProperty("es.internal.spark.sql.required.columns");
        Object object = StringUtils.hasText(requiredFields) ? ((Properties)rowInfo._1()).setProperty("_", requiredFields) : BoxedUnit.UNIT;
        return var3_3;
    }

    private void doDetectInfo(Tuple2<Properties, Properties> info, String level, DataType dataType) {
        block2: {
            while (true) {
                DataType dataType2;
                if ((dataType2 = dataType) instanceof StructType) {
                    StructType structType = (StructType)dataType2;
                    ArrayList fields = new ArrayList();
                    structType.foreach((Function1 & Serializable & scala.Serializable)field -> {
                        SchemaUtils$.$anonfun$doDetectInfo$1(fields, info, level, field);
                        return BoxedUnit.UNIT;
                    });
                    ((Properties)info._1()).setProperty(level, StringUtils.concatenate(fields, ","));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block2;
                }
                if (!(dataType2 instanceof ArrayType)) break;
                ArrayType arrayType = (ArrayType)dataType2;
                String prop = ((Properties)info._2()).getProperty(level);
                int depth = (StringUtils.hasText(prop) ? Integer.parseInt(prop) : 0) + 1;
                ((Properties)info._2()).setProperty(level, String.valueOf(depth));
                dataType = arrayType.elementType();
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$doDetectInfo$1(ArrayList fields$1, Tuple2 info$1, String level$1, StructField field) {
        fields$1.add(field.name());
        String string = level$1;
        String string2 = "_";
        MODULE$.doDetectInfo((Tuple2<Properties, Properties>)info$1, (string == null ? string2 != null : !string.equals(string2)) ? new StringBuilder(1).append(level$1).append(".").append(field.name()).toString() : field.name(), field.dataType());
    }

    private SchemaUtils$() {
        MODULE$ = this;
    }
}

