/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.mr.security;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.elasticsearch.hadoop.EsHadoopException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.mr.security.EsTokenIdentifier;
import org.elasticsearch.hadoop.mr.security.HadoopRealUserProvider;
import org.elasticsearch.hadoop.security.EsToken;
import org.elasticsearch.hadoop.security.User;
import org.elasticsearch.hadoop.security.UserProvider;
import org.elasticsearch.hadoop.serialization.EsHadoopSerializationException;

public class HadoopUser
implements User {
    private final Settings providerSettings;
    private final UserGroupInformation ugi;

    public HadoopUser(UserGroupInformation ugi, Settings providerSettings) {
        this.ugi = ugi;
        this.providerSettings = providerSettings;
    }

    @Override
    public <T> T doAs(PrivilegedAction<T> action) {
        return (T)this.ugi.doAs(action);
    }

    @Override
    public <T> T doAs(PrivilegedExceptionAction<T> action) throws EsHadoopException {
        try {
            return (T)this.ugi.doAs(action);
        }
        catch (IOException e) {
            throw new EsHadoopException(e);
        }
        catch (InterruptedException e) {
            throw new EsHadoopException(e);
        }
        catch (UndeclaredThrowableException e) {
            throw new EsHadoopException(e);
        }
    }

    @Override
    public EsToken getEsToken(String clusterName) {
        if (clusterName == null || clusterName.equals("") || clusterName.equals("!UNNAMED!")) {
            return null;
        }
        for (Token token : this.ugi.getTokens()) {
            if (!EsTokenIdentifier.KIND_NAME.equals((Object)token.getKind()) || !clusterName.equals(token.getService().toString())) continue;
            try {
                return new EsToken(new DataInputStream(new ByteArrayInputStream(token.getPassword())));
            }
            catch (IOException e) {
                throw new EsHadoopSerializationException("Could not read token information from UGI", e);
            }
        }
        return null;
    }

    @Override
    public Iterable<EsToken> getAllEsTokens() {
        ArrayList<EsToken> tokens = new ArrayList<EsToken>();
        for (Token token : this.ugi.getTokens()) {
            if (!EsTokenIdentifier.KIND_NAME.equals((Object)token.getKind())) continue;
            try {
                tokens.add(new EsToken(new DataInputStream(new ByteArrayInputStream(token.getPassword()))));
            }
            catch (IOException e) {
                throw new EsHadoopSerializationException("Could not read token information from UGI", e);
            }
        }
        return Collections.unmodifiableList(tokens);
    }

    @Override
    public void addEsToken(EsToken esToken) {
        Token<EsTokenIdentifier> token = EsTokenIdentifier.createTokenFrom(esToken);
        this.ugi.addToken(token);
    }

    @Override
    public String getUserName() {
        return this.ugi.getUserName();
    }

    @Override
    public KerberosPrincipal getKerberosPrincipal() {
        if (this.ugi.hasKerberosCredentials()) {
            return new KerberosPrincipal(this.ugi.getUserName());
        }
        return null;
    }

    @Override
    public boolean isProxyUser() {
        return UserGroupInformation.AuthenticationMethod.PROXY.equals((Object)this.ugi.getAuthenticationMethod());
    }

    @Override
    public UserProvider getRealUserProvider() {
        HadoopRealUserProvider realProvider = new HadoopRealUserProvider();
        realProvider.setSettings(this.providerSettings);
        return realProvider;
    }

    public String toString() {
        return "HadoopUser{ugi=" + this.ugi + '}';
    }
}

