/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.handler;

import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.handler.ErrorCollector;
import org.elasticsearch.hadoop.handler.HandlerResult;

public class SerdeErrorCollector<T>
implements ErrorCollector<T> {
    private boolean isRetry;
    private T currentRetry;
    private String currentMessage;

    @Override
    public HandlerResult retry() {
        this.isRetry = true;
        return HandlerResult.HANDLED;
    }

    @Override
    public HandlerResult retry(T retryData) {
        this.currentRetry = retryData;
        return this.retry();
    }

    @Override
    public HandlerResult pass(String reason) {
        if (this.currentMessage != null) {
            throw new EsHadoopIllegalStateException("Error Handler is attempting to pass with a reason, but a reason already exists! Be sure to return the result of your call to errorCollector.pass(String), and call it only once per call to your Handler!");
        }
        this.currentMessage = reason;
        return HandlerResult.PASS;
    }

    public boolean receivedRetries() {
        return this.isRetry;
    }

    public T getAndClearRetryValue() {
        if (this.isRetry) {
            T data = null;
            if (this.currentRetry != null) {
                data = this.currentRetry;
                this.currentRetry = null;
            }
            this.isRetry = false;
            return data;
        }
        return null;
    }

    public String getAndClearMessage() {
        String msg = this.currentMessage;
        this.currentMessage = null;
        return msg;
    }
}

