/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.Header;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.HttpConnection;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.HttpException;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.HttpMethod;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.HttpMethodBase;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.HttpState;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.Wire;

public class ConnectMethod
extends HttpMethodBase {
    public static final String NAME = "CONNECT";
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$ConnectMethod == null ? (class$org$apache$commons$httpclient$ConnectMethod = ConnectMethod.class$("org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.ConnectMethod")) : class$org$apache$commons$httpclient$ConnectMethod));
    static /* synthetic */ Class class$org$apache$commons$httpclient$ConnectMethod;

    public ConnectMethod() {
        LOG.trace((Object)"enter ConnectMethod()");
    }

    public ConnectMethod(HttpMethod method) {
        LOG.trace((Object)"enter ConnectMethod(HttpMethod)");
    }

    public String getName() {
        return NAME;
    }

    protected void addCookieRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
    }

    protected void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace((Object)"enter ConnectMethod.addRequestHeaders(HttpState, HttpConnection)");
        this.addUserAgentRequestHeader(state, conn);
        this.addHostRequestHeader(state, conn);
        this.addProxyConnectionHeader(state, conn);
    }

    public int execute(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace((Object)"enter ConnectMethod.execute(HttpState, HttpConnection)");
        int code = super.execute(state, conn);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("CONNECT status code " + code));
        }
        return code;
    }

    protected void writeRequestLine(HttpState state, HttpConnection conn) throws IOException, HttpException {
        int port = conn.getPort();
        if (port == -1) {
            port = conn.getProtocol().getDefaultPort();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        buffer.append(' ');
        buffer.append(conn.getHost());
        if (port > -1) {
            buffer.append(':');
            buffer.append(port);
        }
        buffer.append(" ");
        buffer.append(this.getEffectiveVersion());
        String line = buffer.toString();
        conn.printLine(line, this.getParams().getHttpElementCharset());
        if (Wire.HEADER_WIRE.enabled()) {
            Wire.HEADER_WIRE.output(line);
        }
    }

    protected boolean shouldCloseConnection(HttpConnection conn) {
        if (this.getStatusCode() == 200) {
            Header connectionHeader = null;
            if (!conn.isTransparent()) {
                connectionHeader = this.getResponseHeader("proxy-connection");
            }
            if (connectionHeader == null) {
                connectionHeader = this.getResponseHeader("connection");
            }
            if (connectionHeader != null && connectionHeader.getValue().equalsIgnoreCase("close") && LOG.isWarnEnabled()) {
                LOG.warn((Object)("Invalid header encountered '" + connectionHeader.toExternalForm() + "' in response " + this.getStatusLine().toString()));
            }
            return false;
        }
        return super.shouldCloseConnection(conn);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

