/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.deploy.yarn.security;

import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.security.ServiceCredentialProvider;
import org.elasticsearch.hadoop.cfg.CompositeSettings;
import org.elasticsearch.hadoop.cfg.HadoopSettingsManager;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.mr.security.EsTokenIdentifier;
import org.elasticsearch.hadoop.mr.security.HadoopUserProvider;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.rest.RestClient;
import org.elasticsearch.hadoop.security.AuthenticationMethod;
import org.elasticsearch.hadoop.security.EsToken;
import org.elasticsearch.hadoop.security.User;
import org.elasticsearch.hadoop.security.UserProvider;
import org.elasticsearch.spark.cfg.SparkSettingsManager;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!4Aa\u0002\u0005\u0001+!)a\u0005\u0001C\u0001O!1!\u0006\u0001Q\u0001\n-BQa\r\u0001\u0005BQBQ\u0001\u0011\u0001\u0005B\u0005CQ\u0001\u0011\u0001\u0005\u0002=CQa\u0016\u0001\u0005Ba\u00131$R:TKJ4\u0018nY3De\u0016$WM\u001c;jC2\u0004&o\u001c<jI\u0016\u0014(BA\u0005\u000b\u0003!\u0019XmY;sSRL(BA\u0006\r\u0003\u0011I\u0018M\u001d8\u000b\u00055q\u0011A\u00023fa2|\u0017P\u0003\u0002\u0010!\u0005)1\u000f]1sW*\u0011\u0011CE\u0001\u000eK2\f7\u000f^5dg\u0016\f'o\u00195\u000b\u0003M\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\f\u001d!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0019\te.\u001f*fMB\u0011Q\u0004J\u0007\u0002=)\u0011\u0011b\b\u0006\u0003\u0017\u0001R!!D\u0011\u000b\u0005=\u0011#BA\u0012\u0013\u0003\u0019\t\u0007/Y2iK&\u0011QE\b\u0002\u001a'\u0016\u0014h/[2f\u0007J,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u0011\u0011\u0006A\u0007\u0002\u0011\u0005\u0019AjT$\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013a\u00027pO\u001eLgn\u001a\u0006\u0003a\t\nqaY8n[>t7/\u0003\u00023[\t\u0019Aj\\4\u0002\u0017M,'O^5dK:\u000bW.Z\u000b\u0002kA\u0011a'\u0010\b\u0003om\u0002\"\u0001\u000f\r\u000e\u0003eR!A\u000f\u000b\u0002\rq\u0012xn\u001c;?\u0013\ta\u0004$\u0001\u0004Qe\u0016$WMZ\u0005\u0003}}\u0012aa\u0015;sS:<'B\u0001\u001f\u0019\u0003M\u0019'/\u001a3f]RL\u0017\r\\:SKF,\u0018N]3e)\t\u0011U\t\u0005\u0002\u0018\u0007&\u0011A\t\u0007\u0002\b\u0005>|G.Z1o\u0011\u00151E\u00011\u0001H\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0003\u00116k\u0011!\u0013\u0006\u0003\u0015.\u000bAaY8oM*\u0011AJI\u0001\u0007Q\u0006$wn\u001c9\n\u00059K%!D\"p]\u001aLw-\u001e:bi&|g\u000eF\u0002C!ZCQ!U\u0003A\u0002I\u000b\u0011b\u001d9be.\u001cuN\u001c4\u0011\u0005M#V\"A\u0011\n\u0005U\u000b#!C*qCJ\\7i\u001c8g\u0011\u00151U\u00011\u0001H\u0003Ey'\r^1j]\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\u00053~\u0003\u0017\rE\u0002\u00185rK!a\u0017\r\u0003\r=\u0003H/[8o!\t9R,\u0003\u0002_1\t!Aj\u001c8h\u0011\u00151e\u00011\u0001H\u0011\u0015\tf\u00011\u0001S\u0011\u0015\u0011g\u00011\u0001d\u0003\u0015\u0019'/\u001a3t!\t!g-D\u0001f\u0015\tI1*\u0003\u0002hK\nY1I]3eK:$\u0018.\u00197t\u0001")
public class EsServiceCredentialProvider
implements ServiceCredentialProvider {
    private final Log LOG;

    public String serviceName() {
        return "elasticsearch";
    }

    public boolean credentialsRequired(Configuration hadoopConf) {
        return this.credentialsRequired(null, hadoopConf);
    }

    public boolean credentialsRequired(SparkConf sparkConf, Configuration hadoopConf) {
        Settings settings = sparkConf != null ? new CompositeSettings(Arrays.asList((Object[])new Settings[]{new SparkSettingsManager().load(sparkConf), new HadoopSettingsManager().load(hadoopConf)})) : HadoopSettingsManager.loadFrom(hadoopConf);
        boolean isSecurityEnabled = UserGroupInformation.isSecurityEnabled();
        AuthenticationMethod esAuthMethod = settings.getSecurityAuthenticationMethod();
        boolean required = isSecurityEnabled && AuthenticationMethod.KERBEROS.equals((Object)esAuthMethod);
        this.LOG.info((Object)new StringBuilder(28).append("Hadoop Security Enabled = [").append(isSecurityEnabled).append("]").toString());
        this.LOG.info((Object)new StringBuilder(19).append("ES Auth Method = [").append((Object)esAuthMethod).append("]").toString());
        this.LOG.info((Object)new StringBuilder(23).append("Are creds required = [").append(required).append("]").toString());
        return required;
    }

    public Option<Object> obtainCredentials(Configuration hadoopConf, SparkConf sparkConf, Credentials creds) {
        Some some;
        CompositeSettings settings = new CompositeSettings(Arrays.asList((Object[])new Settings[]{new SparkSettingsManager().load(sparkConf), new HadoopSettingsManager().load(hadoopConf)}));
        InitializationUtils.setUserProviderIfNotSet(settings, HadoopUserProvider.class, LogFactory.getLog(EsServiceCredentialProvider.class));
        UserProvider userProvider = UserProvider.create(settings);
        try (RestClient client = new RestClient(settings);){
            User user = userProvider.getUser();
            EsToken esToken = user.doAs(new PrivilegedExceptionAction<EsToken>(null, client){
                private final RestClient client$1;

                public EsToken run() {
                    return this.client$1.createNewApiToken(new StringBuilder(9).append("ESHADOOP_").append(UUID.randomUUID().toString()).toString());
                }
                {
                    this.client$1 = client$1;
                }
            });
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info((Object)new StringBuilder(45).append("getting token for: Elasticsearch[tokenName=").append(esToken.getName()).append(", ").append(new StringBuilder(20).append("clusterName=").append(esToken.getClusterName()).append(", user=").append(user).append("]").toString()).toString());
            }
            long expiration = esToken.getExpirationTime();
            Token<EsTokenIdentifier> token = EsTokenIdentifier.createTokenFrom(esToken);
            creds.addToken(token.getService(), token);
            some = new Some((Object)BoxesRunTime.boxToLong((long)expiration));
        }
        return some;
    }

    public EsServiceCredentialProvider() {
        ServiceCredentialProvider.$init$((ServiceCredentialProvider)this);
        this.LOG = LogFactory.getLog(EsServiceCredentialProvider.class);
        this.LOG.info((Object)"Loaded EsServiceCredentialProvider");
    }
}

