/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import java.io.Serializable;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;

public class EsMajorVersion
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final EsMajorVersion V_0_X = new EsMajorVersion(0, "0.x");
    public static final EsMajorVersion V_1_X = new EsMajorVersion(1, "1.x");
    public static final EsMajorVersion V_2_X = new EsMajorVersion(2, "2.x");
    public static final EsMajorVersion V_5_X = new EsMajorVersion(5, "5.x");
    public static final EsMajorVersion V_6_X = new EsMajorVersion(6, "6.x");
    public static final EsMajorVersion V_7_X = new EsMajorVersion(7, "7.x");
    public static final EsMajorVersion V_8_X;
    public static final EsMajorVersion LATEST;
    public final byte major;
    private final String version;

    private EsMajorVersion(byte major, String version) {
        this.major = major;
        this.version = version;
    }

    public boolean after(EsMajorVersion version) {
        return version.major < this.major;
    }

    public boolean on(EsMajorVersion version) {
        return version.major == this.major;
    }

    public boolean notOn(EsMajorVersion version) {
        return !this.on(version);
    }

    public boolean onOrAfter(EsMajorVersion version) {
        return version.major <= this.major;
    }

    public boolean before(EsMajorVersion version) {
        return version.major > this.major;
    }

    public boolean onOrBefore(EsMajorVersion version) {
        return version.major >= this.major;
    }

    public static EsMajorVersion parse(String version) {
        if (version.startsWith("0.")) {
            return new EsMajorVersion(0, version);
        }
        if (version.startsWith("1.")) {
            return new EsMajorVersion(1, version);
        }
        if (version.startsWith("2.")) {
            return new EsMajorVersion(2, version);
        }
        if (version.startsWith("5.")) {
            return new EsMajorVersion(5, version);
        }
        if (version.startsWith("6.")) {
            return new EsMajorVersion(6, version);
        }
        if (version.startsWith("7.")) {
            return new EsMajorVersion(7, version);
        }
        if (version.startsWith("8.")) {
            return new EsMajorVersion(8, version);
        }
        throw new EsHadoopIllegalArgumentException("Unsupported/Unknown Elasticsearch version [" + version + "].Highest supported version is [" + EsMajorVersion.LATEST.version + "]. You may need to upgrade ES-Hadoop.");
    }

    public int parseMinorVersion(String versionString) {
        String majorPrefix = "" + this.major + ".";
        if (!versionString.startsWith(majorPrefix)) {
            throw new EsHadoopIllegalArgumentException("Invalid version string for major version; Received [" + versionString + "] for major version [" + this.version + "]");
        }
        String minorRemainder = versionString.substring(majorPrefix.length());
        int dot = minorRemainder.indexOf(46);
        if (dot < 1) {
            throw new EsHadoopIllegalArgumentException("Could not parse Elasticsearch minor version [" + versionString + "]. Invalid version format.");
        }
        String rawMinorVersion = minorRemainder.substring(0, dot);
        try {
            return Integer.parseInt(rawMinorVersion);
        }
        catch (NumberFormatException e) {
            throw new EsHadoopIllegalArgumentException("Could not parse Elasticsearch minor version [" + versionString + "]. Non-numeric minor version [" + rawMinorVersion + "].", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EsMajorVersion version = (EsMajorVersion)o;
        return this.major == version.major && this.version.equals(version.version);
    }

    public int hashCode() {
        return this.major;
    }

    public String toString() {
        return this.version;
    }

    static {
        LATEST = V_8_X = new EsMajorVersion(8, "8.x");
    }
}

