/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.cfg;

import java.io.InputStream;
import java.util.Properties;
import org.apache.spark.SparkConf;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.IOUtils;
import scala.Option;
import scala.Tuple2;

public class SparkSettings
extends Settings {
    private final SparkConf cfg;

    public SparkSettings(SparkConf cfg) {
        Assert.notNull(cfg, "non-null spark configuration expected");
        this.cfg = cfg;
    }

    @Override
    public InputStream loadResource(String location) {
        return IOUtils.open(location);
    }

    @Override
    public Settings copy() {
        return new SparkSettings(this.cfg.clone());
    }

    @Override
    public String getProperty(String name) {
        Option op = this.cfg.getOption(name);
        if (!op.isDefined()) {
            op = this.cfg.getOption("spark." + name);
        }
        return op.isDefined() ? (String)op.get() : null;
    }

    @Override
    public void setProperty(String name, String value) {
        this.cfg.set(name, value);
    }

    @Override
    public Properties asProperties() {
        Properties props = new Properties();
        if (this.cfg != null) {
            String sparkPrefix = "spark.";
            for (Tuple2 tuple : this.cfg.getAll()) {
                String simpleKey;
                String key = (String)tuple._1;
                props.setProperty(key, (String)tuple._2);
                if (!key.startsWith(sparkPrefix) || props.containsKey(simpleKey = key.substring(sparkPrefix.length()))) continue;
                props.setProperty(simpleKey, (String)tuple._2);
            }
        }
        return props;
    }
}

