/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.memcached;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.memcached.MemcachedServerTransport;
import org.elasticsearch.node.service.NodeService;
import org.elasticsearch.rest.RestController;

public class MemcachedServer
extends AbstractLifecycleComponent<MemcachedServer> {
    private final MemcachedServerTransport transport;
    private final NodeService nodeService;
    private final RestController restController;

    @Inject
    public MemcachedServer(Settings settings, MemcachedServerTransport transport, RestController restController, NodeService nodeService) {
        super(settings);
        this.transport = transport;
        this.restController = restController;
        this.nodeService = nodeService;
    }

    protected void doStart() throws ElasticSearchException {
        this.transport.start();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("{}", new Object[]{this.transport.boundAddress()});
        }
        this.nodeService.putNodeAttribute("memcached_address", this.transport.boundAddress().publishAddress().toString());
    }

    protected void doStop() throws ElasticSearchException {
        this.nodeService.removeNodeAttribute("memcached_address");
        this.transport.stop();
    }

    protected void doClose() throws ElasticSearchException {
        this.transport.close();
    }
}

