/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.memcached.netty;

import java.io.StreamCorruptedException;
import java.util.regex.Pattern;
import org.elasticsearch.Version;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.ExceptionEvent;
import org.elasticsearch.common.netty.handler.codec.frame.FrameDecoder;
import org.elasticsearch.memcached.MemcachedRestRequest;
import org.elasticsearch.memcached.netty.MemcachedDispatcher;
import org.elasticsearch.rest.RestRequest;

public class MemcachedDecoder
extends FrameDecoder {
    private final ESLogger logger;
    private final Pattern lineSplit = Pattern.compile(" +");
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte[] CRLF = new byte[]{13, 10};
    private volatile StringBuffer sb = new StringBuffer();
    private volatile MemcachedRestRequest request;
    private volatile boolean ending = false;

    public MemcachedDecoder(ESLogger logger) {
        super(false);
        this.logger = logger;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        int readableBytes;
        StringBuffer sb;
        boolean done;
        MemcachedRestRequest request = this.request;
        if (request == null) {
            buffer.markReaderIndex();
            if (buffer.readableBytes() < 1) {
                return null;
            }
            short magic = buffer.readUnsignedByte();
            if (magic == 128) {
                if (buffer.readableBytes() < 23) {
                    buffer.resetReaderIndex();
                    return null;
                }
                short opcode = buffer.readUnsignedByte();
                short keyLength = buffer.readShort();
                short extraLength = buffer.readUnsignedByte();
                short dataType = buffer.readUnsignedByte();
                short reserved = buffer.readShort();
                int totalBodyLength = buffer.readInt();
                int opaque = buffer.readInt();
                long cas = buffer.readLong();
                if (buffer.readableBytes() < totalBodyLength) {
                    buffer.resetReaderIndex();
                    return null;
                }
                buffer.skipBytes((int)extraLength);
                if (opcode == 0) {
                    byte[] key = new byte[keyLength];
                    buffer.readBytes(key);
                    String uri = Unicode.fromBytes((byte[])key);
                    request = new MemcachedRestRequest(RestRequest.Method.GET, uri, key, -1, true);
                    request.setOpaque(opaque);
                    return request;
                }
                if (opcode == 4) {
                    byte[] key = new byte[keyLength];
                    buffer.readBytes(key);
                    String uri = Unicode.fromBytes((byte[])key);
                    request = new MemcachedRestRequest(RestRequest.Method.DELETE, uri, key, -1, true);
                    request.setOpaque(opaque);
                    return request;
                }
                if (opcode == 1) {
                    byte[] key = new byte[keyLength];
                    buffer.readBytes(key);
                    String uri = Unicode.fromBytes((byte[])key);
                    int size = totalBodyLength - keyLength - extraLength;
                    request = new MemcachedRestRequest(RestRequest.Method.POST, uri, key, size, true);
                    request.setOpaque(opaque);
                    byte[] data = new byte[size];
                    buffer.readBytes(data, 0, size);
                    request.setData(data);
                    request.setQuiet(opcode == 17);
                    return request;
                }
                if (opcode == 10 || opcode == 16) {
                    ChannelBuffer writeBuffer = ChannelBuffers.dynamicBuffer((int)24);
                    writeBuffer.writeByte(129);
                    writeBuffer.writeByte((int)opcode);
                    writeBuffer.writeShort(0);
                    writeBuffer.writeByte(0);
                    writeBuffer.writeByte(0);
                    writeBuffer.writeShort(0);
                    writeBuffer.writeInt(0);
                    writeBuffer.writeInt(opaque);
                    writeBuffer.writeLong(0L);
                    channel.write((Object)writeBuffer);
                    return MemcachedDispatcher.IGNORE_REQUEST;
                }
                if (opcode == 7) {
                    channel.disconnect();
                    return null;
                }
                this.logger.error("Unsupported opcode [0x{}], ignoring and closing connection", new Object[]{Integer.toHexString(opcode)});
                channel.disconnect();
                return null;
            }
            buffer.resetReaderIndex();
            done = false;
            sb = this.sb;
            readableBytes = buffer.readableBytes();
        } else {
            if (buffer.readableBytes() < request.getDataSize() + 2) {
                return null;
            }
            byte[] data = new byte[request.getDataSize()];
            buffer.readBytes(data, 0, data.length);
            byte next = buffer.readByte();
            if (next != 13) {
                this.request = null;
                throw new StreamCorruptedException("Expecting separator after data block");
            }
            next = buffer.readByte();
            if (next == 10) {
                request.setData(data);
                this.request = null;
                return request;
            }
            this.request = null;
            throw new StreamCorruptedException("Expecting separator after data block");
        }
        for (int i = 0; i < readableBytes; ++i) {
            byte next = buffer.readByte();
            if (!this.ending && next == 13) {
                this.ending = true;
                continue;
            }
            if (this.ending && next == 10) {
                this.ending = false;
                done = true;
                break;
            }
            if (this.ending) {
                this.logger.error("Corrupt stream, expected LF, found [0x{}]", new Object[]{Integer.toHexString(next)});
                throw new StreamCorruptedException("Expecting LF after CR");
            }
            sb.append((char)next);
        }
        if (!done) {
            buffer.markReaderIndex();
            return null;
        }
        String[] args = this.lineSplit.split(sb);
        sb.setLength(0);
        String cmd = args[0];
        if ("get".equals(cmd)) {
            request = new MemcachedRestRequest(RestRequest.Method.GET, args[1], null, -1, false);
            if (args.length <= 3) return request;
            request.setData(Unicode.fromStringAsBytes((String)args[2]));
            return request;
        }
        if ("delete".equals(cmd)) {
            return new MemcachedRestRequest(RestRequest.Method.DELETE, args[1], null, -1, false);
        }
        if ("set".equals(cmd)) {
            this.request = new MemcachedRestRequest(RestRequest.Method.POST, args[1], null, Integer.parseInt(args[4]), false);
            buffer.markReaderIndex();
            return null;
        }
        if ("version".equals(cmd)) {
            byte[] bytes = Version.CURRENT.toString().getBytes();
            ChannelBuffer writeBuffer = ChannelBuffers.dynamicBuffer((int)bytes.length);
            writeBuffer.writeBytes(bytes);
            channel.write((Object)writeBuffer);
            return MemcachedDispatcher.IGNORE_REQUEST;
        }
        if ("quit".equals(cmd)) {
            if (!channel.isConnected()) return null;
            channel.disconnect();
            return null;
        }
        this.logger.error("Unsupported command [{}], ignoring and closing connection", new Object[]{cmd});
        if (!channel.isConnected()) return null;
        channel.disconnect();
        return null;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.request = null;
        this.ending = false;
        this.sb.setLength(0);
        if (ctx.getChannel().isConnected()) {
            ctx.getChannel().disconnect();
        }
        this.logger.error("caught exception on memcached decoder", new Object[]{e});
    }
}

