/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.memcached.netty;

import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.MessageEvent;
import org.elasticsearch.common.netty.channel.SimpleChannelUpstreamHandler;
import org.elasticsearch.memcached.MemcachedRestRequest;
import org.elasticsearch.memcached.netty.MemcachedRestChannel;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.StringRestResponse;

public class MemcachedDispatcher
extends SimpleChannelUpstreamHandler {
    public static final Object IGNORE_REQUEST = new Object();
    private final RestController restController;

    public MemcachedDispatcher(RestController restController) {
        this.restController = restController;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        MemcachedRestChannel channel;
        if (e.getMessage() == IGNORE_REQUEST) {
            super.messageReceived(ctx, e);
            return;
        }
        MemcachedRestRequest request = (MemcachedRestRequest)((Object)e.getMessage());
        if (!this.restController.dispatchRequest((RestRequest)request, (RestChannel)(channel = new MemcachedRestChannel(ctx.getChannel(), request)))) {
            channel.sendResponse((RestResponse)new StringRestResponse(RestStatus.BAD_REQUEST, "No handler found for uri [" + request.uri() + "] and method [" + request.method() + "]"));
        }
        super.messageReceived(ctx, e);
    }
}

