/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.memcached.netty;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.netty.OpenChannelsHandler;
import org.elasticsearch.common.netty.bootstrap.ServerBootstrap;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelFactory;
import org.elasticsearch.common.netty.channel.ChannelHandler;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.ChannelPipelineFactory;
import org.elasticsearch.common.netty.channel.Channels;
import org.elasticsearch.common.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.elasticsearch.common.netty.channel.socket.oio.OioServerSocketChannelFactory;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.network.NetworkUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.http.BindHttpException;
import org.elasticsearch.memcached.MemcachedServerTransport;
import org.elasticsearch.memcached.netty.MemcachedDecoder;
import org.elasticsearch.memcached.netty.MemcachedDispatcher;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.transport.BindTransportException;

public class NettyMemcachedServerTransport
extends AbstractLifecycleComponent<MemcachedServerTransport>
implements MemcachedServerTransport {
    private final RestController restController;
    private final NetworkService networkService;
    private final int workerCount;
    private final boolean blockingServer;
    private final String port;
    private final String bindHost;
    private final String publishHost;
    private final Boolean tcpNoDelay;
    private final Boolean tcpKeepAlive;
    private final Boolean reuseAddress;
    private final ByteSizeValue tcpSendBufferSize;
    private final ByteSizeValue tcpReceiveBufferSize;
    private volatile ServerBootstrap serverBootstrap;
    private volatile BoundTransportAddress boundAddress;
    private volatile Channel serverChannel;
    private volatile OpenChannelsHandler serverOpenChannels;

    @Inject
    public NettyMemcachedServerTransport(Settings settings, RestController restController, NetworkService networkService) {
        super(settings);
        this.restController = restController;
        this.networkService = networkService;
        this.workerCount = this.componentSettings.getAsInt("worker_count", Integer.valueOf(Runtime.getRuntime().availableProcessors() * 2));
        this.blockingServer = this.componentSettings.getAsBoolean("memcached.blocking_server", settings.getAsBoolean("network.tcp.blocking_server", settings.getAsBoolean("network.tcp.blocking", Boolean.valueOf(false))));
        this.port = this.componentSettings.get("port", settings.get("memcached.port", "11211-11311"));
        this.bindHost = this.componentSettings.get("bind_host");
        this.publishHost = this.componentSettings.get("publish_host");
        this.tcpNoDelay = this.componentSettings.getAsBoolean("tcp_no_delay", settings.getAsBoolean("network.tcp.no_delay", Boolean.valueOf(true)));
        this.tcpKeepAlive = this.componentSettings.getAsBoolean("tcp_keep_alive", settings.getAsBoolean("network.tcp.keep_alive", Boolean.valueOf(true)));
        this.reuseAddress = this.componentSettings.getAsBoolean("reuse_address", settings.getAsBoolean("network.tcp.reuse_address", NetworkUtils.defaultReuseAddress()));
        this.tcpSendBufferSize = this.componentSettings.getAsBytesSize("tcp_send_buffer_size", settings.getAsBytesSize("network.tcp.send_buffer_size", NetworkService.TcpSettings.TCP_DEFAULT_SEND_BUFFER_SIZE));
        this.tcpReceiveBufferSize = this.componentSettings.getAsBytesSize("tcp_receive_buffer_size", settings.getAsBytesSize("network.tcp.receive_buffer_size", NetworkService.TcpSettings.TCP_DEFAULT_RECEIVE_BUFFER_SIZE));
    }

    @Override
    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    protected void doStart() throws ElasticSearchException {
        InetSocketAddress publishAddress;
        InetAddress hostAddressX;
        this.serverOpenChannels = new OpenChannelsHandler();
        this.serverBootstrap = this.blockingServer ? new ServerBootstrap((ChannelFactory)new OioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"memcached_server_boss")), (Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"memcached_server_worker")))) : new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"memcached_server_boss")), (Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"memcached_server_worker")), this.workerCount));
        ChannelPipelineFactory pipelineFactory = new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("openChannels", (ChannelHandler)NettyMemcachedServerTransport.this.serverOpenChannels);
                pipeline.addLast("decoder", (ChannelHandler)new MemcachedDecoder(NettyMemcachedServerTransport.this.logger));
                pipeline.addLast("dispatcher", (ChannelHandler)new MemcachedDispatcher(NettyMemcachedServerTransport.this.restController));
                return pipeline;
            }
        };
        this.serverBootstrap.setPipelineFactory(pipelineFactory);
        if (this.tcpNoDelay != null) {
            this.serverBootstrap.setOption("child.tcpNoDelay", (Object)this.tcpNoDelay);
        }
        if (this.tcpKeepAlive != null) {
            this.serverBootstrap.setOption("child.keepAlive", (Object)this.tcpKeepAlive);
        }
        if (this.tcpSendBufferSize != null) {
            this.serverBootstrap.setOption("child.sendBufferSize", (Object)this.tcpSendBufferSize.bytes());
        }
        if (this.tcpReceiveBufferSize != null) {
            this.serverBootstrap.setOption("child.receiveBufferSize", (Object)this.tcpReceiveBufferSize.bytes());
        }
        if (this.reuseAddress != null) {
            this.serverBootstrap.setOption("reuseAddress", (Object)this.reuseAddress);
            this.serverBootstrap.setOption("child.reuseAddress", (Object)this.reuseAddress);
        }
        try {
            hostAddressX = this.networkService.resolveBindHostAddress(this.bindHost);
        }
        catch (IOException e) {
            throw new BindHttpException("Failed to resolve host [" + this.bindHost + "]", (Throwable)e);
        }
        final InetAddress hostAddress = hostAddressX;
        PortsRange portsRange = new PortsRange(this.port);
        final AtomicReference lastException = new AtomicReference();
        boolean success = portsRange.iterate(new PortsRange.PortCallback(){

            public boolean onPortNumber(int portNumber) {
                try {
                    NettyMemcachedServerTransport.this.serverChannel = NettyMemcachedServerTransport.this.serverBootstrap.bind((SocketAddress)new InetSocketAddress(hostAddress, portNumber));
                }
                catch (Exception e) {
                    lastException.set(e);
                    return false;
                }
                return true;
            }
        });
        if (!success) {
            throw new BindHttpException("Failed to bind to [" + this.port + "]", (Throwable)lastException.get());
        }
        InetSocketAddress boundAddress = (InetSocketAddress)this.serverChannel.getLocalAddress();
        try {
            publishAddress = new InetSocketAddress(this.networkService.resolvePublishHostAddress(this.publishHost), boundAddress.getPort());
        }
        catch (Exception e) {
            throw new BindTransportException("Failed to resolve publish address", (Throwable)e);
        }
        this.boundAddress = new BoundTransportAddress((TransportAddress)new InetSocketTransportAddress(boundAddress), (TransportAddress)new InetSocketTransportAddress(publishAddress));
    }

    protected void doStop() throws ElasticSearchException {
        if (this.serverChannel != null) {
            this.serverChannel.close().awaitUninterruptibly();
            this.serverChannel = null;
        }
        if (this.serverOpenChannels != null) {
            this.serverOpenChannels.close();
            this.serverOpenChannels = null;
        }
        if (this.serverBootstrap != null) {
            this.serverBootstrap.releaseExternalResources();
            this.serverBootstrap = null;
        }
    }

    protected void doClose() throws ElasticSearchException {
    }
}

