/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.transport.memcached;

import java.util.ArrayList;
import java.util.Collection;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.memcached.MemcachedServer;
import org.elasticsearch.memcached.MemcachedServerModule;
import org.elasticsearch.plugins.AbstractPlugin;

public class MemcachedTransportPlugin
extends AbstractPlugin {
    private final Settings settings;

    public MemcachedTransportPlugin(Settings settings) {
        this.settings = settings;
    }

    public String name() {
        return "transport-memcached";
    }

    public String description() {
        return "Exports elasticsearch APIs over memcached";
    }

    public Collection<Class<? extends Module>> modules() {
        ArrayList modules = Lists.newArrayList();
        if (this.settings.getAsBoolean("memcached.enabled", Boolean.valueOf(true)).booleanValue()) {
            modules.add(MemcachedServerModule.class);
        }
        return modules;
    }

    public Collection<Class<? extends LifecycleComponent>> services() {
        ArrayList services = Lists.newArrayList();
        if (this.settings.getAsBoolean("memcached.enabled", Boolean.valueOf(true)).booleanValue()) {
            services.add(MemcachedServer.class);
        }
        return services;
    }
}

