/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.wares;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;

abstract class AbstractServletRestChannel
extends RestChannel {
    protected AbstractServletRestChannel(RestRequest request) {
        super(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(RestResponse response) {
        HttpServletResponse resp = this.getServletResponse();
        resp.setStatus(response.status().getStatus());
        resp.setContentType(response.contentType());
        String opaque = this.request.header("X-Opaque-Id");
        if (opaque != null) {
            resp.addHeader("X-Opaque-Id", opaque);
        }
        try {
            resp.setContentLength(response.content().length());
            ServletOutputStream out = resp.getOutputStream();
            response.content().writeTo((OutputStream)out);
            out.close();
        }
        catch (IOException e) {
            this.errorOccured(e);
        }
        finally {
            this.finish();
        }
    }

    protected abstract HttpServletResponse getServletResponse();

    protected abstract void errorOccured(IOException var1);

    protected abstract void finish();
}

