/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.wares;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.wares.AbstractServletRestChannel;
import org.elasticsearch.wares.NodeServlet;
import org.elasticsearch.wares.ServletRestRequest;

public class AsyncNodeServlet
extends NodeServlet {
    @Override
    public void init() throws ServletException {
        super.init();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        AsyncContext asyncContext = req.startAsync();
        ServletRestRequest request = new ServletRestRequest(req);
        AsyncServletRestChannel channel = new AsyncServletRestChannel(request, asyncContext);
        this.restController.dispatchRequest((RestRequest)request, (RestChannel)channel);
    }

    static class AsyncServletRestChannel
    extends AbstractServletRestChannel {
        final AsyncContext asyncContext;

        AsyncServletRestChannel(RestRequest restRequest, AsyncContext asyncContext) {
            super(restRequest);
            this.asyncContext = asyncContext;
        }

        @Override
        protected HttpServletResponse getServletResponse() {
            return (HttpServletResponse)this.asyncContext.getResponse();
        }

        @Override
        protected void errorOccured(IOException e) {
            this.getServletResponse().setStatus(500);
        }

        @Override
        protected void finish() {
            this.asyncContext.complete();
        }
    }
}

