/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.wares;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.concurrent.CountDownLatch;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.elasticsearch.node.internal.InternalNode;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.wares.AbstractServletRestChannel;
import org.elasticsearch.wares.ServletRestRequest;

public class NodeServlet
extends HttpServlet {
    public static String NODE_KEY = "elasticsearchNode";
    public static String NAME_PREFIX = "org.elasticsearch.";
    protected Node node;
    protected RestController restController;

    public void init() throws ServletException {
        Object nodeAttribute = this.getServletContext().getAttribute(NODE_KEY);
        if (nodeAttribute == null || !(nodeAttribute instanceof InternalNode)) {
            if (nodeAttribute != null) {
                this.getServletContext().log("Warning: overwriting attribute with key \"" + NODE_KEY + "\" and type \"" + nodeAttribute.getClass().getName() + "\".");
            }
            this.getServletContext().log("Initializing elasticsearch Node '" + this.getServletName() + "'");
            ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder();
            InputStream resourceAsStream = this.getServletContext().getResourceAsStream("/WEB-INF/elasticsearch.json");
            if (resourceAsStream != null) {
                settings.loadFromStream("/WEB-INF/elasticsearch.json", resourceAsStream);
                try {
                    resourceAsStream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if ((resourceAsStream = this.getServletContext().getResourceAsStream("/WEB-INF/elasticsearch.yml")) != null) {
                settings.loadFromStream("/WEB-INF/elasticsearch.yml", resourceAsStream);
                try {
                    resourceAsStream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            Enumeration enumeration = this.getServletContext().getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (!key.startsWith(NAME_PREFIX)) continue;
                Object attribute = this.getServletContext().getAttribute(key);
                if (attribute != null) {
                    attribute = attribute.toString();
                }
                settings.put(key.substring(NAME_PREFIX.length()), (String)attribute);
            }
            if (settings.get("http.enabled") == null) {
                settings.put("http.enabled", false);
            }
            this.node = NodeBuilder.nodeBuilder().settings((Settings.Builder)settings).node();
            this.getServletContext().setAttribute(NODE_KEY, (Object)this.node);
        } else {
            this.getServletContext().log("Using pre-initialized elasticsearch Node '" + this.getServletName() + "'");
            this.node = (InternalNode)nodeAttribute;
        }
        this.restController = (RestController)((InternalNode)this.node).injector().getInstance(RestController.class);
    }

    public void destroy() {
        if (this.node != null) {
            this.getServletContext().removeAttribute(NODE_KEY);
            this.node.close();
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletRestRequest request = new ServletRestRequest(req);
        ServletRestChannel channel = new ServletRestChannel(request, resp);
        try {
            this.restController.dispatchRequest((RestRequest)request, (RestChannel)channel);
            channel.latch.await();
        }
        catch (Exception e) {
            throw new IOException("failed to dispatch request", e);
        }
        if (channel.sendFailure != null) {
            throw channel.sendFailure;
        }
    }

    static class ServletRestChannel
    extends AbstractServletRestChannel {
        final HttpServletResponse resp;
        final CountDownLatch latch;
        IOException sendFailure;

        ServletRestChannel(RestRequest restRequest, HttpServletResponse resp) {
            super(restRequest);
            this.resp = resp;
            this.latch = new CountDownLatch(1);
        }

        @Override
        protected HttpServletResponse getServletResponse() {
            return this.resp;
        }

        @Override
        protected void errorOccured(IOException e) {
            this.sendFailure = e;
        }

        @Override
        protected void finish() {
            this.latch.countDown();
        }
    }
}

