/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.wares;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.support.RestUtils;

public class ServletRestRequest
extends RestRequest {
    private final HttpServletRequest servletRequest;
    private final RestRequest.Method method;
    private final Map<String, String> params;
    private final byte[] content;

    public ServletRestRequest(HttpServletRequest servletRequest) throws IOException {
        this.servletRequest = servletRequest;
        this.method = RestRequest.Method.valueOf((String)servletRequest.getMethod());
        this.params = new HashMap<String, String>();
        if (servletRequest.getQueryString() != null) {
            RestUtils.decodeQueryString((String)servletRequest.getQueryString(), (int)0, this.params);
        }
        this.content = Streams.copyToByteArray((InputStream)servletRequest.getInputStream());
    }

    public RestRequest.Method method() {
        return this.method;
    }

    public String uri() {
        String queryString = this.servletRequest.getQueryString();
        if (queryString != null && !queryString.trim().isEmpty()) {
            return this.servletRequest.getRequestURI().substring(this.servletRequest.getContextPath().length() + this.servletRequest.getServletPath().length()) + "?" + queryString;
        }
        return this.servletRequest.getRequestURI().substring(this.servletRequest.getContextPath().length() + this.servletRequest.getServletPath().length());
    }

    public String rawPath() {
        return this.servletRequest.getRequestURI().substring(this.servletRequest.getContextPath().length() + this.servletRequest.getServletPath().length());
    }

    public boolean hasContent() {
        return this.content.length > 0;
    }

    public boolean contentUnsafe() {
        return false;
    }

    public BytesReference content() {
        return new BytesArray(this.content);
    }

    public String header(String name) {
        return this.servletRequest.getHeader(name);
    }

    public Iterable<Map.Entry<String, String>> headers() {
        if (this.servletRequest.getHeaderNames() == null) {
            return null;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration e = this.servletRequest.getHeaderNames();
        while (e.hasMoreElements()) {
            String headerName = (String)e.nextElement();
            headers.put(headerName, this.servletRequest.getHeader(headerName));
        }
        return ImmutableList.copyOf(headers.entrySet());
    }

    public Map<String, String> params() {
        return this.params;
    }

    public boolean hasParam(String key) {
        return this.params.containsKey(key);
    }

    public String param(String key) {
        return this.params.get(key);
    }

    public String param(String key, String defaultValue) {
        String value = this.params.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }
}

