/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.function.Function;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.tasks.Exec;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.process.JavaExecSpec;

public class LoggedExec
extends Exec {
    public LoggedExec() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ByteArrayOutputStream error = new ByteArrayOutputStream();
        if (!this.getLogger().isInfoEnabled()) {
            this.setStandardOutput(output);
            this.setErrorOutput(error);
            this.setIgnoreExitValue(true);
            this.doLast(unused -> {
                if (this.getExecResult().getExitValue() != 0) {
                    try {
                        this.getLogger().error("Standard output:");
                        this.getLogger().error(output.toString("UTF-8"));
                        this.getLogger().error("Standard error:");
                        this.getLogger().error(error.toString("UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new GradleException("Failed to read exec output", (Throwable)e);
                    }
                    throw new GradleException(String.format("Process '%s %s' finished with non-zero exit value %d", this.getExecutable(), this.getArgs(), this.getExecResult().getExitValue()));
                }
            });
        }
    }

    public static ExecResult exec(Project project, Action<ExecSpec> action) {
        return LoggedExec.genericExec(project, arg_0 -> ((Project)project).exec(arg_0), action);
    }

    public static ExecResult javaexec(Project project, Action<JavaExecSpec> action) {
        return LoggedExec.genericExec(project, arg_0 -> ((Project)project).javaexec(arg_0), action);
    }

    private static <T extends BaseExecSpec> ExecResult genericExec(Project project, Function<Action<T>, ExecResult> function, Action<T> action) {
        if (project.getLogger().isInfoEnabled()) {
            return function.apply(action);
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ByteArrayOutputStream error = new ByteArrayOutputStream();
        try {
            return function.apply(spec -> {
                spec.setStandardOutput((OutputStream)output);
                spec.setErrorOutput((OutputStream)error);
                action.execute(spec);
            });
        }
        catch (Exception e) {
            try {
                project.getLogger().error("Standard output:");
                project.getLogger().error(output.toString("UTF-8"));
                project.getLogger().error("Standard error:");
                project.getLogger().error(error.toString("UTF-8"));
            }
            catch (UnsupportedEncodingException ue) {
                throw new GradleException("Failed to read exec output", (Throwable)ue);
            }
            throw e;
        }
    }
}

