/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.gradle.Version;
import org.elasticsearch.gradle.VersionProperties;

public class VersionCollection {
    private static final Pattern LINE_PATTERN = Pattern.compile("\\W+public static final Version V_(\\d+)_(\\d+)_(\\d+)(_alpha\\d+|_beta\\d+|_rc\\d+)? .*");
    private final Version currentVersion;
    private final Map<Integer, List<Version>> groupByMajor;

    public VersionCollection(List<String> versionLines) {
        this(versionLines, Version.fromString(VersionProperties.getElasticsearch()));
    }

    protected VersionCollection(List<String> versionLines, Version currentVersionProperty) {
        this.groupByMajor = versionLines.stream().map(LINE_PATTERN::matcher).filter(Matcher::matches).map(match -> new Version(Integer.parseInt(match.group(1)), Integer.parseInt(match.group(2)), Integer.parseInt(match.group(3)))).sorted().distinct().collect(Collectors.groupingBy(Version::getMajor, Collectors.toList()));
        if (this.groupByMajor.isEmpty()) {
            throw new IllegalArgumentException("Could not parse any versions");
        }
        this.currentVersion = this.getLatestVersionByKey(this.groupByMajor, (Integer)this.groupByMajor.keySet().stream().max(Integer::compareTo).orElseThrow(() -> new IllegalStateException("Unexpected number of versions in collection")));
        Version previousMajorUnreleased = this.getLatestVersionByKey(this.groupByMajor, this.currentVersion.getMajor() - 1);
        this.groupByMajor.get(this.currentVersion.getMajor() - 1).remove(previousMajorUnreleased);
        this.assertCurrentVersionMatchesParsed(currentVersionProperty);
        this.assertNoOlderThanTwoMajors();
    }

    private void assertNoOlderThanTwoMajors() {
        Set<Integer> majors = this.groupByMajor.keySet();
        if (majors.size() != 2 && this.currentVersion.getMinor() != 0 && this.currentVersion.getRevision() != 0) {
            throw new IllegalStateException("Expected exactly 2 majors in parsed versions but found: " + majors);
        }
    }

    private void assertCurrentVersionMatchesParsed(Version currentVersionProperty) {
        if (!currentVersionProperty.equals(this.currentVersion)) {
            throw new IllegalStateException("Parsed versions latest version does not match the one configured in build properties. Parsed latest version is " + this.currentVersion + " but the build has " + currentVersionProperty);
        }
    }

    public void forPreviousUnreleased(Consumer<UnreleasedVersionInfo> consumer) {
        this.getUnreleased().stream().filter(version -> !version.equals(this.currentVersion)).forEach(version -> consumer.accept(new UnreleasedVersionInfo((Version)version, this.getBranchFor((Version)version), this.getGradleProjectNameFor((Version)version))));
    }

    private String getGradleProjectNameFor(Version version) {
        if (version.equals(this.currentVersion)) {
            throw new IllegalArgumentException("The Gradle project to build " + version + " is the current build.");
        }
        Map<Integer, List<Version>> releasedMajorGroupedByMinor = this.getReleasedMajorGroupedByMinor();
        if (version.getRevision() == 0) {
            if (releasedMajorGroupedByMinor.get(releasedMajorGroupedByMinor.keySet().stream().max(Integer::compareTo).orElse(0)).contains(version)) {
                return "minor";
            }
            return "staged";
        }
        if (releasedMajorGroupedByMinor.getOrDefault(version.getMinor(), Collections.emptyList()).contains(version)) {
            return "bugfix";
        }
        return "maintenance";
    }

    private String getBranchFor(Version version) {
        switch (this.getGradleProjectNameFor(version)) {
            case "minor": {
                return version.getMajor() + ".x";
            }
            case "staged": 
            case "maintenance": 
            case "bugfix": {
                return version.getMajor() + "." + version.getMinor();
            }
        }
        throw new IllegalStateException("Unexpected Gradle project name");
    }

    public List<Version> getUnreleased() {
        ArrayList<Version> unreleased = new ArrayList<Version>();
        unreleased.add(this.currentVersion);
        Map<Integer, List<Version>> groupByMinor = this.getReleasedMajorGroupedByMinor();
        int greatestMinor = groupByMinor.keySet().stream().max(Integer::compareTo).orElse(0);
        unreleased.add(this.getLatestVersionByKey(groupByMinor, greatestMinor));
        if (groupByMinor.get(greatestMinor).size() == 1) {
            unreleased.add(this.getLatestVersionByKey(groupByMinor, greatestMinor - 1));
            if (groupByMinor.getOrDefault(greatestMinor - 1, Collections.emptyList()).size() == 1) {
                unreleased.add(this.getLatestVersionByKey(groupByMinor, greatestMinor - 2));
            }
        }
        return Collections.unmodifiableList(unreleased.stream().sorted().distinct().collect(Collectors.toList()));
    }

    private Version getLatestVersionByKey(Map<Integer, List<Version>> groupByMajor, int key) {
        return (Version)groupByMajor.getOrDefault(key, Collections.emptyList()).stream().max(Version::compareTo).orElseThrow(() -> new IllegalStateException("Unexpected number of versions in collection"));
    }

    private Map<Integer, List<Version>> getReleasedMajorGroupedByMinor() {
        List<Version> currentMajorVersions = this.groupByMajor.get(this.currentVersion.getMajor());
        List<Version> previousMajorVersions = this.groupByMajor.get(this.currentVersion.getMajor() - 1);
        Map<Integer, List<Version>> groupByMinor = currentMajorVersions.size() == 1 ? previousMajorVersions.stream().collect(Collectors.groupingBy(Version::getMinor, Collectors.toList())) : currentMajorVersions.stream().collect(Collectors.groupingBy(Version::getMinor, Collectors.toList()));
        return groupByMinor;
    }

    public void compareToAuthoritative(List<Version> authoritativeReleasedVersions) {
        HashSet<Version> notReallyReleased = new HashSet<Version>(this.getReleased());
        notReallyReleased.removeAll(authoritativeReleasedVersions);
        if (!notReallyReleased.isEmpty()) {
            throw new IllegalStateException("out-of-date released versions\nFollowing versions are not really released, but the build thinks they are: " + notReallyReleased);
        }
        HashSet<Version> incorrectlyConsideredUnreleased = new HashSet<Version>(authoritativeReleasedVersions);
        incorrectlyConsideredUnreleased.retainAll(this.getUnreleased());
        if (!incorrectlyConsideredUnreleased.isEmpty()) {
            throw new IllegalStateException("out-of-date released versions\nBuild considers versions unreleased, but they are released according to an authoritative source: " + incorrectlyConsideredUnreleased + "\nThe next versions probably needs to be added to Version.java (CURRENT doesn't count).");
        }
    }

    private List<Version> getReleased() {
        List<Version> unreleased = this.getUnreleased();
        return this.groupByMajor.values().stream().flatMap(Collection::stream).filter(each -> !unreleased.contains(each)).collect(Collectors.toList());
    }

    public List<Version> getIndexCompatible() {
        return Collections.unmodifiableList(Stream.concat(this.groupByMajor.get(this.currentVersion.getMajor() - 1).stream(), this.groupByMajor.get(this.currentVersion.getMajor()).stream()).filter(version -> !version.equals(this.currentVersion)).collect(Collectors.toList()));
    }

    public List<Version> getWireCompatible() {
        ArrayList<Version> wireCompat = new ArrayList<Version>();
        List<Version> prevMajors = this.groupByMajor.get(this.currentVersion.getMajor() - 1);
        int minor = prevMajors.get(prevMajors.size() - 1).getMinor();
        for (int i = prevMajors.size() - 1; i > 0 && prevMajors.get(i).getMinor() == minor; --i) {
            wireCompat.add(prevMajors.get(i));
        }
        wireCompat.addAll((Collection)this.groupByMajor.get(this.currentVersion.getMajor()));
        wireCompat.remove(this.currentVersion);
        wireCompat.sort(Version::compareTo);
        return Collections.unmodifiableList(wireCompat);
    }

    public List<Version> getUnreleasedIndexCompatible() {
        ArrayList<Version> unreleasedIndexCompatible = new ArrayList<Version>(this.getIndexCompatible());
        unreleasedIndexCompatible.retainAll(this.getUnreleased());
        return Collections.unmodifiableList(unreleasedIndexCompatible);
    }

    public List<Version> getUnreleasedWireCompatible() {
        ArrayList<Version> unreleasedWireCompatible = new ArrayList<Version>(this.getWireCompatible());
        unreleasedWireCompatible.retainAll(this.getUnreleased());
        return Collections.unmodifiableList(unreleasedWireCompatible);
    }

    public class UnreleasedVersionInfo {
        public final Version version;
        public final String branch;
        public final String gradleProjectName;

        UnreleasedVersionInfo(Version version, String branch, String gradleProjectName) {
            this.version = version;
            this.branch = branch;
            this.gradleProjectName = gradleProjectName;
        }
    }
}

