/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.precommit;

import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.gradle.precommit.TestingConventionRule;
import org.elasticsearch.gradle.tool.Boilerplate;
import org.gradle.api.DefaultTask;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.util.PatternFilterable;

public class TestingConventionsTasks
extends DefaultTask {
    private static final String TEST_METHOD_PREFIX = "test";
    private Map<String, File> testClassNames;
    private final NamedDomainObjectContainer<TestingConventionRule> naming;

    public TestingConventionsTasks() {
        this.setDescription("Tests various testing conventions");
        Boilerplate.getJavaSourceSets(this.getProject()).all(sourceSet -> this.dependsOn(new Object[]{sourceSet.getOutput().getClassesDirs()}));
        this.naming = this.getProject().container(TestingConventionRule.class);
    }

    @Input
    public Map<String, Set<File>> classFilesPerEnabledTask(FileTree testClassFiles) {
        HashMap<String, Set> collector = new HashMap<String, Set>();
        collector.putAll(this.getProject().getTasks().withType(this.getRandomizedTestingTask()).stream().filter(Task::getEnabled).collect(Collectors.toMap(Task::getPath, task -> testClassFiles.matching(this.getRandomizedTestingPatternSet((Task)task)).getFiles())));
        collector.putAll(this.getProject().getTasks().withType(Test.class).stream().filter(Task::getEnabled).collect(Collectors.toMap(Task::getPath, task -> task.getCandidateClassFiles().getFiles())));
        return Collections.unmodifiableMap(collector);
    }

    @Input
    public Map<String, File> getTestClassNames() {
        if (this.testClassNames == null) {
            this.testClassNames = ((SourceSet)Boilerplate.getJavaSourceSets(this.getProject()).getByName(TEST_METHOD_PREFIX)).getOutput().getClassesDirs().getFiles().stream().filter(File::exists).flatMap(testRoot -> this.walkPathAndLoadClasses((File)testRoot).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return this.testClassNames;
    }

    @Input
    public NamedDomainObjectContainer<TestingConventionRule> getNaming() {
        return this.naming;
    }

    @OutputFile
    public File getSuccessMarker() {
        return new File(this.getProject().getBuildDir(), "markers/" + this.getName());
    }

    public void naming(Closure<TestingConventionRule> action) {
        this.naming.configure(action);
    }

    @Input
    public Set<String> getMainClassNamedLikeTests() {
        SourceSetContainer javaSourceSets = Boilerplate.getJavaSourceSets(this.getProject());
        if (javaSourceSets.findByName("main") == null) {
            return Collections.emptySet();
        }
        return ((SourceSet)javaSourceSets.getByName("main")).getOutput().getClassesDirs().getAsFileTree().getFiles().stream().filter(file -> file.getName().endsWith(".class")).map(File::getName).map(name -> name.substring(0, name.length() - 6)).filter(this::implementsNamingConvention).collect(Collectors.toSet());
    }

    @TaskAction
    public void doCheck() throws IOException {
        String problems;
        try (URLClassLoader isolatedClassLoader = new URLClassLoader((URL[])this.getTestsClassPath().getFiles().stream().map(this::fileToUrl).toArray(URL[]::new));){
            Predicate<Class> isStaticClass = clazz -> Modifier.isStatic(clazz.getModifiers());
            Predicate<Class> isPublicClass = clazz -> Modifier.isPublic(clazz.getModifiers());
            Predicate<Class> isAbstractClass = clazz -> Modifier.isAbstract(clazz.getModifiers());
            Map<File, Class> classes = this.getTestClassNames().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, entry -> this.loadClassWithoutInitializing((String)entry.getKey(), isolatedClassLoader)));
            FileTree allTestClassFiles = this.getProject().files(new Object[]{classes.values().stream().filter(isStaticClass.negate()).filter(isPublicClass).filter(this::implementsNamingConvention).map(clazz -> this.testClassNames.get(clazz.getName())).collect(Collectors.toList())}).getAsFileTree();
            Map<String, Set<File>> classFilesPerTask = this.classFilesPerEnabledTask(allTestClassFiles);
            Map<String, Set> testClassesPerTask = classFilesPerTask.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Set)entry.getValue()).stream().map(classes::get).filter(this::implementsNamingConvention).collect(Collectors.toSet())));
            Map<Object, Object> suffixToBaseClass = classes.isEmpty() ? Collections.emptyMap() : this.naming.stream().collect(Collectors.toMap(TestingConventionRule::getSuffix, rule -> rule.getBaseClasses().stream().map(each -> this.loadClassWithoutInitializing((String)each, isolatedClassLoader)).collect(Collectors.toSet())));
            String[] stringArray = new String[6];
            stringArray[0] = this.checkNoneExists("Test classes implemented by inner classes will not run", classes.values().stream().filter(isStaticClass).filter(isPublicClass).filter(((Predicate<Class>)this::implementsNamingConvention).or(this::seemsLikeATest)));
            stringArray[1] = this.checkNoneExists("Seem like test classes but don't match naming convention", classes.values().stream().filter(isStaticClass.negate()).filter(isPublicClass).filter(isAbstractClass.negate()).filter(this::seemsLikeATest).filter(((Predicate<Class>)this::implementsNamingConvention).negate()));
            stringArray[2] = this.collectProblems(testClassesPerTask.entrySet().stream().map(entry -> this.checkAtLeastOneExists("test class included in task " + (String)entry.getKey(), ((Set)entry.getValue()).stream())).sorted().collect(Collectors.joining("\n")));
            stringArray[3] = this.checkNoneExists("Test classes are not included in any enabled task (" + classFilesPerTask.keySet().stream().collect(Collectors.joining(",")) + ")", allTestClassFiles.getFiles().stream().filter(testFile -> !classFilesPerTask.values().stream().anyMatch(fileSet -> fileSet.contains(testFile))).map(classes::get));
            stringArray[4] = this.collectProblems(suffixToBaseClass.entrySet().stream().filter(entry -> !((Set)entry.getValue()).isEmpty()).map(entry -> this.checkNoneExists("Tests classes with suffix `" + (String)entry.getKey() + "` should extend " + ((Set)entry.getValue()).stream().map(Class::getName).collect(Collectors.joining(" or ")) + " but the following classes do not", classes.values().stream().filter(clazz -> clazz.getName().endsWith((String)entry.getKey())).filter(clazz -> !((Set)entry.getValue()).stream().anyMatch(test -> test.isAssignableFrom((Class<?>)clazz))))).sorted().collect(Collectors.joining("\n")));
            stringArray[5] = this.checkNoneExists("Classes matching the test naming convention should be in test not main", this.getMainClassNamedLikeTests());
            problems = this.collectProblems(stringArray);
        }
        if (!problems.isEmpty()) {
            this.getLogger().error(problems);
            throw new IllegalStateException("Testing conventions are not honored");
        }
        this.getSuccessMarker().getParentFile().mkdirs();
        Files.write(this.getSuccessMarker().toPath(), new byte[0], StandardOpenOption.CREATE);
    }

    private String collectProblems(String ... problems) {
        return Stream.of(problems).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.joining("\n"));
    }

    private PatternFilterable getRandomizedTestingPatternSet(Task task) {
        try {
            if (!this.getRandomizedTestingTask().isAssignableFrom(task.getClass())) {
                throw new IllegalStateException("Expected " + task + " to be RandomizedTestingTask or Test but it was " + task.getClass());
            }
            Method getPatternSet = task.getClass().getMethod("getPatternSet", new Class[0]);
            return (PatternFilterable)getPatternSet.invoke((Object)task, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Expecte task to have a `patternSet` " + task, e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to get pattern set from task" + task, e);
        }
    }

    private Class<? extends Task> getRandomizedTestingTask() {
        try {
            return Class.forName("com.carrotsearch.gradle.junit4.RandomizedTestingTask");
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw new IllegalStateException("Failed to load randomized testing class", e);
        }
    }

    private String checkNoneExists(String message, Stream<? extends Class<?>> stream) {
        String problem = stream.map(each -> "  * " + each.getName()).sorted().collect(Collectors.joining("\n"));
        if (!problem.isEmpty()) {
            return message + ":\n" + problem;
        }
        return "";
    }

    private String checkNoneExists(String message, Set<? extends String> candidates) {
        String problem = candidates.stream().map(each -> "  * " + each).sorted().collect(Collectors.joining("\n"));
        if (!problem.isEmpty()) {
            return message + ":\n" + problem;
        }
        return "";
    }

    private String checkAtLeastOneExists(String message, Stream<? extends Class<?>> stream) {
        if (stream.findAny().isPresent()) {
            return "";
        }
        return "Expected at least one " + message + ", but found none.";
    }

    private boolean seemsLikeATest(Class<?> clazz) {
        try {
            ClassLoader classLoader = clazz.getClassLoader();
            Class<?> junitTest = this.loadClassWithoutInitializing("org.junit.Assert", classLoader);
            if (junitTest.isAssignableFrom(clazz)) {
                this.getLogger().debug("{} is a test because it extends {}", (Object)clazz.getName(), (Object)junitTest.getName());
                return true;
            }
            Class<?> junitAnnotation = this.loadClassWithoutInitializing("org.junit.Test", classLoader);
            for (Method method : clazz.getMethods()) {
                if (this.matchesTestMethodNamingConvention(method)) {
                    this.getLogger().debug("{} is a test because it has method named '{}'", (Object)clazz.getName(), (Object)method.getName());
                    return true;
                }
                if (!this.isAnnotated(method, junitAnnotation)) continue;
                this.getLogger().debug("{} is a test because it has method '{}' annotated with '{}'", new Object[]{clazz.getName(), method.getName(), junitAnnotation.getName()});
                return true;
            }
            return false;
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalStateException("Failed to inspect class " + clazz.getName() + ". Missing class? " + e.getMessage(), e);
        }
    }

    private boolean implementsNamingConvention(Class<?> clazz) {
        return this.implementsNamingConvention(clazz.getName());
    }

    private boolean implementsNamingConvention(String className) {
        if (this.naming.stream().map(TestingConventionRule::getSuffix).anyMatch(suffix -> className.endsWith((String)suffix))) {
            this.getLogger().debug("{} is a test because it matches the naming convention", (Object)className);
            return true;
        }
        return false;
    }

    private boolean matchesTestMethodNamingConvention(Method method) {
        return method.getName().startsWith(TEST_METHOD_PREFIX) && !Modifier.isStatic(method.getModifiers());
    }

    private boolean isAnnotated(Method method, Class<?> annotation) {
        for (Annotation presentAnnotation : method.getAnnotations()) {
            if (!annotation.isAssignableFrom(presentAnnotation.getClass())) continue;
            return true;
        }
        return false;
    }

    private FileCollection getTestsClassPath() {
        return this.getProject().files(new Object[]{this.getProject().getConfigurations().getByName("testRuntime").resolve(), Boilerplate.getJavaSourceSets(this.getProject()).stream().flatMap(sourceSet -> sourceSet.getOutput().getClassesDirs().getFiles().stream()).collect(Collectors.toList())});
    }

    private Map<String, File> walkPathAndLoadClasses(File testRoot) {
        final HashMap<String, File> classes = new HashMap<String, File>();
        try {
            Files.walkFileTree(testRoot.toPath(), (FileVisitor<? super Path>)new FileVisitor<Path>(){
                private String packageName;

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    this.packageName = this.packageName == null ? "" : this.packageName + dir.getFileName() + ".";
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    this.packageName = this.packageName.substring(0, 1 + this.packageName.lastIndexOf(46, this.packageName.length() - 2));
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String filename = file.getFileName().toString();
                    if (filename.endsWith(".class")) {
                        String className = filename.substring(0, filename.length() - ".class".length());
                        classes.put(this.packageName + className, file.toFile());
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    throw new IOException("Failed to visit " + file, exc);
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return classes;
    }

    private Class<?> loadClassWithoutInitializing(String name, ClassLoader isolatedClassLoader) {
        try {
            return Class.forName(name, false, isolatedClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load class " + name + ". Incorrect test runtime classpath?", e);
        }
    }

    private URL fileToUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }
}

