/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testclusters;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.elasticsearch.GradleServicesAdapter;
import org.elasticsearch.gradle.testclusters.ElasticsearchNode;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskState;

public class TestClustersPlugin
implements Plugin<Project> {
    private static final String LIST_TASK_NAME = "listTestClusters";
    private static final String NODE_EXTENSION_NAME = "testClusters";
    static final String HELPER_CONFIGURATION_NAME = "testclusters";
    private static final String SYNC_ARTIFACTS_TASK_NAME = "syncTestClustersArtifacts";
    private static final int EXECUTOR_SHUTDOWN_TIMEOUT = 1;
    private static final TimeUnit EXECUTOR_SHUTDOWN_TIMEOUT_UNIT = TimeUnit.MINUTES;
    private static final Logger logger = Logging.getLogger(TestClustersPlugin.class);
    private static final Map<Task, List<ElasticsearchNode>> usedClusters = new ConcurrentHashMap<Task, List<ElasticsearchNode>>();
    private static final Map<ElasticsearchNode, Integer> claimsInventory = new ConcurrentHashMap<ElasticsearchNode, Integer>();
    private static final Set<ElasticsearchNode> runningClusters = Collections.synchronizedSet(new HashSet());
    private static volatile ExecutorService executorService;

    public void apply(Project project) {
        Project rootProject = project.getRootProject();
        NamedDomainObjectContainer<ElasticsearchNode> container = this.createTestClustersContainerExtension(project);
        this.createListClustersTask(project, container);
        TestClustersPlugin.createUseClusterTaskExtension(project);
        if (rootProject.getConfigurations().findByName(HELPER_CONFIGURATION_NAME) == null) {
            Configuration helperConfiguration = (Configuration)project.getRootProject().getConfigurations().create(HELPER_CONFIGURATION_NAME);
            helperConfiguration.setDescription("Internal helper configuration used by cluster configuration to download ES distributions and plugins.");
            helperConfiguration.getIncoming().afterResolve(resolvableDependencies -> {
                Set nonZipComponents = resolvableDependencies.getArtifacts().getArtifacts().stream().filter(artifact -> !artifact.getFile().getName().endsWith(".zip")).map(artifact -> artifact.getId()).collect(Collectors.toSet());
                if (!nonZipComponents.isEmpty()) {
                    throw new IllegalStateException("Dependencies with non-zip artifacts found in configuration 'testclusters': " + nonZipComponents);
                }
            });
            usedClusters.clear();
            claimsInventory.clear();
            runningClusters.clear();
            rootProject.getTasks().create(SYNC_ARTIFACTS_TASK_NAME, Sync.class, sync -> {
                sync.from(new Object[]{() -> helperConfiguration.getFiles().stream().map(arg_0 -> ((Project)project).zipTree(arg_0)).collect(Collectors.toList())});
                sync.into((Object)new File(TestClustersPlugin.getTestClustersConfigurationExtractDir(project), "zip"));
            });
            TestClustersPlugin.configureClaimClustersHook(project);
            TestClustersPlugin.configureStartClustersHook(project);
            TestClustersPlugin.configureStopClustersHook(project);
            TestClustersPlugin.configureCleanupHooks(project);
            TestClustersPlugin.autoConfigureClusterDependencies(project, rootProject, container);
        }
    }

    private NamedDomainObjectContainer<ElasticsearchNode> createTestClustersContainerExtension(Project project) {
        NamedDomainObjectContainer container = project.container(ElasticsearchNode.class, name -> new ElasticsearchNode(project.getPath(), name, GradleServicesAdapter.getInstance(project), TestClustersPlugin.getTestClustersConfigurationExtractDir(project), new File(project.getBuildDir(), HELPER_CONFIGURATION_NAME)));
        project.getExtensions().add(NODE_EXTENSION_NAME, (Object)container);
        return container;
    }

    private void createListClustersTask(Project project, NamedDomainObjectContainer<ElasticsearchNode> container) {
        Task listTask = project.getTasks().create(LIST_TASK_NAME);
        listTask.setGroup("ES cluster formation");
        listTask.setDescription("Lists all ES clusters configured for this project");
        listTask.doLast(task -> container.forEach(cluster -> logger.lifecycle("   * {}: {}", new Object[]{cluster.getName(), cluster.getDistribution()})));
    }

    private static void createUseClusterTaskExtension(final Project project) {
        project.getTasks().all(task -> ((ExtraPropertiesExtension)task.getExtensions().findByType(ExtraPropertiesExtension.class)).set("useCluster", (Object)new Closure<Void>((Object)project, task){

            public void doCall(ElasticsearchNode node) {
                Object thisObject = this.getThisObject();
                if (!(thisObject instanceof Task)) {
                    throw new AssertionError((Object)("Expected " + thisObject + " to be an instance of Task, but got: " + thisObject.getClass()));
                }
                usedClusters.computeIfAbsent(task, k -> new ArrayList()).add(node);
                ((Task)thisObject).dependsOn(new Object[]{project.getRootProject().getTasks().getByName(TestClustersPlugin.SYNC_ARTIFACTS_TASK_NAME)});
            }
        }));
    }

    private static void configureClaimClustersHook(Project project) {
        project.getGradle().getTaskGraph().whenReady(taskExecutionGraph -> taskExecutionGraph.getAllTasks().forEach(task -> usedClusters.getOrDefault(task, Collections.emptyList()).forEach(each -> {
            Map<ElasticsearchNode, Integer> map = claimsInventory;
            synchronized (map) {
                claimsInventory.put((ElasticsearchNode)each, claimsInventory.getOrDefault(each, 0) + 1);
            }
            each.freeze();
        })));
    }

    private static void configureStartClustersHook(Project project) {
        project.getGradle().addListener((Object)new TaskActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void beforeActions(Task task) {
                List<ElasticsearchNode> clustersToStart;
                Set set = runningClusters;
                synchronized (set) {
                    clustersToStart = usedClusters.getOrDefault(task, Collections.emptyList()).stream().filter(each -> !runningClusters.contains(each)).collect(Collectors.toList());
                    runningClusters.addAll(clustersToStart);
                }
                clustersToStart.forEach(ElasticsearchNode::start);
            }

            public void afterActions(Task task) {
            }
        });
    }

    private static void configureStopClustersHook(Project project) {
        project.getGradle().addListener((Object)new TaskExecutionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterExecute(Task task, TaskState state) {
                List<ElasticsearchNode> clustersUsedByTask = usedClusters.getOrDefault(task, Collections.emptyList());
                if (state.getFailure() != null) {
                    clustersUsedByTask.forEach(each -> each.stop(true));
                } else {
                    List<ElasticsearchNode> stoppable;
                    clustersUsedByTask.forEach(each -> {
                        Map map = claimsInventory;
                        synchronized (map) {
                            claimsInventory.put(each, (Integer)claimsInventory.get(each) - 1);
                        }
                    });
                    Set set = runningClusters;
                    synchronized (set) {
                        stoppable = claimsInventory.entrySet().stream().filter(entry -> (Integer)entry.getValue() == 0).filter(entry -> runningClusters.contains(entry.getKey())).map(Map.Entry::getKey).collect(Collectors.toList());
                        runningClusters.removeAll(stoppable);
                    }
                    stoppable.forEach(each -> each.stop(false));
                }
            }

            public void beforeExecute(Task task) {
            }
        });
    }

    static File getTestClustersConfigurationExtractDir(Project project) {
        return new File(project.getRootProject().getBuildDir(), "testclusters/extract");
    }

    public static NamedDomainObjectContainer<ElasticsearchNode> getNodeExtension(Project project) {
        return (NamedDomainObjectContainer)project.getExtensions().getByName(NODE_EXTENSION_NAME);
    }

    private static void autoConfigureClusterDependencies(Project project, Project rootProject, NamedDomainObjectContainer<ElasticsearchNode> container) {
        project.afterEvaluate(ip -> container.forEach(esNode -> {
            String dependency = String.format("org.elasticsearch.distribution.zip:%s:%s@zip", esNode.getDistribution().getFileName(), esNode.getVersion());
            logger.info("Cluster {} depends on {}", (Object)esNode.getName(), (Object)dependency);
            rootProject.getDependencies().add(HELPER_CONFIGURATION_NAME, (Object)dependency);
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configureCleanupHooks(Project project) {
        Set<ElasticsearchNode> set = runningClusters;
        synchronized (set) {
            if (executorService != null && !executorService.isTerminated()) {
                throw new IllegalStateException("Trying to configure executor service twice");
            }
            executorService = Executors.newSingleThreadExecutor();
        }
        executorService.submit(() -> {
            try {
                while (true) {
                    Thread.sleep(Long.MAX_VALUE);
                }
            }
            catch (InterruptedException interrupted) {
                TestClustersPlugin.shutDownAllClusters();
                Thread.currentThread().interrupt();
                return;
            }
        });
        project.getGradle().buildFinished(buildResult -> {
            logger.info("Build finished");
            TestClustersPlugin.shutdownExecutorService();
        });
        Runtime.getRuntime().addShutdownHook(new Thread(TestClustersPlugin::shutDownAllClusters));
    }

    private static void shutdownExecutorService() {
        executorService.shutdownNow();
        try {
            if (!executorService.awaitTermination(1L, EXECUTOR_SHUTDOWN_TIMEOUT_UNIT)) {
                throw new IllegalStateException("Failed to shut down executor service after 1 " + EXECUTOR_SHUTDOWN_TIMEOUT_UNIT);
            }
        }
        catch (InterruptedException e) {
            logger.info("Wait for testclusters shutdown interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutDownAllClusters() {
        if (logger.isDebugEnabled()) {
            logger.debug("Shutting down all test clusters", (Throwable)new RuntimeException());
        }
        Set<ElasticsearchNode> set = runningClusters;
        synchronized (set) {
            runningClusters.forEach(each -> each.stop(true));
            runningClusters.clear();
        }
    }
}

