/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testfixtures;

import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;

public class TestFixtureExtension {
    private final Project project;
    final NamedDomainObjectContainer<Project> fixtures;

    public TestFixtureExtension(Project project) {
        this.project = project;
        this.fixtures = project.container(Project.class);
    }

    public void useFixture(String path) {
        Project fixtureProject = this.project.findProject(path);
        if (fixtureProject == null) {
            throw new IllegalArgumentException("Could not find test fixture " + fixtureProject);
        }
        if (!fixtureProject.file((Object)"docker-compose.yml").exists()) {
            throw new IllegalArgumentException("Project " + path + " is not a valid test fixture: missing docker-compose.yml");
        }
        this.fixtures.add((Object)fixtureProject);
    }
}

