/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testfixtures;

import com.avast.gradle.dockercompose.ComposeExtension;
import com.avast.gradle.dockercompose.DockerComposePlugin;
import com.avast.gradle.dockercompose.tasks.ComposeUp;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.function.BiConsumer;
import org.elasticsearch.gradle.precommit.JarHellTask;
import org.elasticsearch.gradle.precommit.TestingConventionsTasks;
import org.elasticsearch.gradle.precommit.ThirdPartyAuditTask;
import org.elasticsearch.gradle.testfixtures.TestFixtureExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.os.OperatingSystem;

public class TestFixturesPlugin
implements Plugin<Project> {
    static final String DOCKER_COMPOSE_YML = "docker-compose.yml";

    public void apply(Project project) {
        TaskContainer tasks = project.getTasks();
        TestFixtureExtension extension = (TestFixtureExtension)project.getExtensions().create("testFixtures", TestFixtureExtension.class, new Object[]{project});
        if (project.file((Object)DOCKER_COMPOSE_YML).exists()) {
            this.disableTaskByType(tasks, this.getTaskClass("org.elasticsearch.gradle.precommit.LicenseHeadersTask"));
            this.disableTaskByType(tasks, ThirdPartyAuditTask.class);
            this.disableTaskByType(tasks, JarHellTask.class);
            Task buildFixture = project.getTasks().create("buildFixture");
            Task pullFixture = project.getTasks().create("pullFixture");
            Task preProcessFixture = project.getTasks().create("preProcessFixture");
            buildFixture.dependsOn(new Object[]{preProcessFixture});
            pullFixture.dependsOn(new Object[]{preProcessFixture});
            Task postProcessFixture = project.getTasks().create("postProcessFixture");
            if (!this.dockerComposeSupported(project)) {
                preProcessFixture.setEnabled(false);
                postProcessFixture.setEnabled(false);
                buildFixture.setEnabled(false);
                pullFixture.setEnabled(false);
                return;
            }
            preProcessFixture.onlyIf(spec -> buildFixture.getEnabled());
            postProcessFixture.onlyIf(spec -> buildFixture.getEnabled());
            project.apply(spec -> spec.plugin(BasePlugin.class));
            project.apply(spec -> spec.plugin(DockerComposePlugin.class));
            ComposeExtension composeExtension = (ComposeExtension)project.getExtensions().getByType(ComposeExtension.class);
            composeExtension.setUseComposeFiles(Collections.singletonList(DOCKER_COMPOSE_YML));
            composeExtension.setRemoveContainers(true);
            composeExtension.setExecutable(project.file((Object)"/usr/local/bin/docker-compose").exists() ? "/usr/local/bin/docker-compose" : "/usr/bin/docker-compose");
            buildFixture.dependsOn(new Object[]{tasks.getByName("composeUp")});
            pullFixture.dependsOn(new Object[]{tasks.getByName("composePull")});
            tasks.getByName("composeUp").mustRunAfter(new Object[]{preProcessFixture});
            tasks.getByName("composePull").mustRunAfter(new Object[]{preProcessFixture});
            postProcessFixture.dependsOn(new Object[]{buildFixture});
            this.configureServiceInfoForTask(postProcessFixture, project, (name, port) -> ((ExtraPropertiesExtension)postProcessFixture.getExtensions().getByType(ExtraPropertiesExtension.class)).set(name, port));
            extension.fixtures.add((Object)project);
        }
        extension.fixtures.matching(fixtureProject -> !fixtureProject.equals(project)).all(fixtureProject -> project.evaluationDependsOn(fixtureProject.getPath()));
        this.conditionTaskByType(tasks, extension, this.getTaskClass("com.carrotsearch.gradle.junit4.RandomizedTestingTask"));
        this.conditionTaskByType(tasks, extension, this.getTaskClass("org.elasticsearch.gradle.test.RestIntegTestTask"));
        this.conditionTaskByType(tasks, extension, TestingConventionsTasks.class);
        this.conditionTaskByType(tasks, extension, ComposeUp.class);
        if (!this.dockerComposeSupported(project)) {
            project.getLogger().warn("Tests for {} require docker-compose at /usr/local/bin/docker-compose or /usr/bin/docker-compose but none could be found so these will be skipped", (Object)project.getPath());
            return;
        }
        tasks.withType(this.getTaskClass("com.carrotsearch.gradle.junit4.RandomizedTestingTask"), task -> extension.fixtures.all(fixtureProject -> {
            fixtureProject.getTasks().matching(it -> it.getName().equals("buildFixture")).all(buildFixture -> task.dependsOn(new Object[]{buildFixture}));
            fixtureProject.getTasks().matching(it -> it.getName().equals("composeDown")).all(composeDown -> task.finalizedBy(new Object[]{composeDown}));
            this.configureServiceInfoForTask((Task)task, (Project)fixtureProject, (name, port) -> this.setSystemProperty((Task)task, (String)name, port));
            task.dependsOn(new Object[]{fixtureProject.getTasks().getByName("postProcessFixture")});
        }));
    }

    private void conditionTaskByType(TaskContainer tasks, TestFixtureExtension extension, Class<? extends DefaultTask> taskClass) {
        tasks.withType(taskClass, task -> task.onlyIf(spec -> !extension.fixtures.stream().anyMatch(fixtureProject -> !fixtureProject.getTasks().getByName("buildFixture").getEnabled())));
    }

    private void configureServiceInfoForTask(Task task, Project fixtureProject, BiConsumer<String, Integer> consumer) {
        task.doFirst(theTask -> ((ComposeExtension)fixtureProject.getExtensions().getByType(ComposeExtension.class)).getServicesInfos().forEach((service, infos) -> {
            infos.getTcpPorts().forEach((container, host) -> {
                String name = "test.fixtures." + service + ".tcp." + container;
                theTask.getLogger().info("port mapping property: {}={}", (Object)name, host);
                consumer.accept(name, (Integer)host);
            });
            infos.getUdpPorts().forEach((container, host) -> {
                String name = "test.fixtures." + service + ".udp." + container;
                theTask.getLogger().info("port mapping property: {}={}", (Object)name, host);
                consumer.accept(name, (Integer)host);
            });
        }));
    }

    public boolean dockerComposeSupported(Project project) {
        if (OperatingSystem.current().isWindows()) {
            return false;
        }
        boolean hasDockerCompose = project.file((Object)"/usr/local/bin/docker-compose").exists() || project.file((Object)"/usr/bin/docker-compose").exists();
        return hasDockerCompose && Boolean.parseBoolean(System.getProperty("tests.fixture.enabled", "true"));
    }

    private void setSystemProperty(Task task, String name, Object value) {
        try {
            Method systemProperty = task.getClass().getMethod("systemProperty", String.class, Object.class);
            systemProperty.invoke((Object)task, name, value);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find systemProperty method on RandomizedTestingTask", e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("Could not call systemProperty method on RandomizedTestingTask", e);
        }
    }

    private void disableTaskByType(TaskContainer tasks, Class<? extends Task> type) {
        tasks.withType(type, task -> task.setEnabled(false));
    }

    private Class<? extends DefaultTask> getTaskClass(String type) {
        Class<?> aClass;
        try {
            aClass = Class.forName(type);
            if (!DefaultTask.class.isAssignableFrom(aClass)) {
                throw new IllegalArgumentException("Not a task type: " + type);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No such task: " + type);
        }
        return aClass;
    }
}

