/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.transform;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.elasticsearch.gradle.transform.UnpackTransform;
import org.elasticsearch.gradle.util.PermissionUtils;
import org.gradle.api.artifacts.transform.TransformOutputs;

public abstract class SymbolicLinkPreservingUntarTransform
implements UnpackTransform {
    private static final Path CURRENT_DIR_PATH = Paths.get(".", new String[0]);

    @Override
    public void unpack(File tarFile, File targetDir, TransformOutputs outputs, boolean asFiletreeOutput) throws IOException {
        Function<String, Path> pathModifier = this.pathResolver();
        TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(tarFile)));
        Path destinationPath = targetDir.toPath();
        TarArchiveEntry entry = tar.getNextTarEntry();
        while (entry != null) {
            Path relativePath = pathModifier.apply(entry.getName());
            if (relativePath == null || relativePath.getFileName().equals(CURRENT_DIR_PATH)) {
                entry = tar.getNextTarEntry();
                continue;
            }
            Path destination = destinationPath.resolve(relativePath);
            Path parent = destination.getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            if (entry.isDirectory()) {
                Files.createDirectory(destination, new FileAttribute[0]);
            } else if (entry.isSymbolicLink()) {
                Files.createSymbolicLink(destination, Paths.get(entry.getLinkName(), new String[0]), new FileAttribute[0]);
            } else {
                Files.createFile(destination, new FileAttribute[0]);
                try (FileOutputStream fos = new FileOutputStream(destination.toFile());){
                    tar.transferTo((OutputStream)fos);
                }
                if (asFiletreeOutput) {
                    outputs.file((Object)destination.toFile());
                }
            }
            if (!entry.isSymbolicLink()) {
                PermissionUtils.chmod(destination, entry.getMode());
            }
            entry = tar.getNextTarEntry();
        }
    }
}

