/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version>,
Serializable {
    private final int major;
    private final int minor;
    private final int revision;
    private final int id;
    private final String qualifier;
    private static final Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(?:-(alpha\\d+|beta\\d+|rc\\d+|SNAPSHOT))?");
    private static final Pattern relaxedPattern = Pattern.compile("v?(\\d+)\\.(\\d+)\\.(\\d+)(?:[\\-+]+([a-zA-Z0-9_]+(?:-[a-zA-Z0-9]+)*))?");

    public Version(int major, int minor, int revision) {
        this(major, minor, revision, null);
    }

    public Version(int major, int minor, int revision, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
        this.id = major * 10000000 + minor * 100000 + revision * 1000;
        this.qualifier = qualifier;
    }

    public static Version fromString(String s) {
        return Version.fromString(s, Mode.STRICT);
    }

    public static Version fromString(String s, Mode mode) {
        Matcher matcher;
        Objects.requireNonNull(s);
        Matcher matcher2 = matcher = mode == Mode.STRICT ? pattern.matcher(s) : relaxedPattern.matcher(s);
        if (!matcher.matches()) {
            String expected = mode == Mode.STRICT ? "major.minor.revision[-(alpha|beta|rc)Number|-SNAPSHOT]" : "major.minor.revision[-extra]";
            throw new IllegalArgumentException("Invalid version format: '" + s + "'. Should be " + expected);
        }
        String qualifier = matcher.group(4);
        return new Version(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), qualifier);
    }

    public String toString() {
        return this.getMajor() + "." + this.getMinor() + "." + this.getRevision();
    }

    public boolean before(Version compareTo) {
        return this.id < compareTo.getId();
    }

    public boolean before(String compareTo) {
        return this.before(Version.fromString(compareTo));
    }

    public boolean onOrBefore(Version compareTo) {
        return this.id <= compareTo.getId();
    }

    public boolean onOrBefore(String compareTo) {
        return this.onOrBefore(Version.fromString(compareTo));
    }

    public boolean onOrAfter(Version compareTo) {
        return this.id >= compareTo.getId();
    }

    public boolean onOrAfter(String compareTo) {
        return this.onOrAfter(Version.fromString(compareTo));
    }

    public boolean after(Version compareTo) {
        return this.id > compareTo.getId();
    }

    public boolean after(String compareTo) {
        return this.after(Version.fromString(compareTo));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.major == version.major && this.minor == version.minor && this.revision == version.revision;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.revision, this.id);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    protected int getId() {
        return this.id;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    @Override
    public int compareTo(Version other) {
        return Integer.compare(this.getId(), other.getId());
    }

    public static enum Mode {
        STRICT,
        RELAXED;

    }
}

