/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.elasticsearch.gradle.Version;
import org.elasticsearch.gradle.VersionProperties;
import org.elasticsearch.gradle.dependencies.CompileOnlyResolvePlugin;
import org.elasticsearch.gradle.jarhell.JarHellPlugin;
import org.elasticsearch.gradle.plugin.PluginPropertiesExtension;
import org.elasticsearch.gradle.plugin.PluginType;
import org.elasticsearch.gradle.test.GradleTestPolicySetupPlugin;
import org.elasticsearch.gradle.testclusters.ElasticsearchCluster;
import org.elasticsearch.gradle.testclusters.RunTask;
import org.elasticsearch.gradle.testclusters.TestClustersPlugin;
import org.elasticsearch.gradle.util.GradleUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.plugins.MavenPublishPlugin;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Zip;

public class PluginBuildPlugin
implements Plugin<Project> {
    public static final String PLUGIN_EXTENSION_NAME = "esplugin";
    public static final String BUNDLE_PLUGIN_TASK_NAME = "bundlePlugin";
    public static final String EXPLODED_BUNDLE_CONFIG = "explodedBundleZip";

    public void apply(Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        project.getPluginManager().apply(TestClustersPlugin.class);
        project.getPluginManager().apply(CompileOnlyResolvePlugin.class);
        project.getPluginManager().apply(JarHellPlugin.class);
        project.getPluginManager().apply(GradleTestPolicySetupPlugin.class);
        PluginPropertiesExtension extension = (PluginPropertiesExtension)project.getExtensions().create(PLUGIN_EXTENSION_NAME, PluginPropertiesExtension.class, new Object[]{project});
        PluginBuildPlugin.configureDependencies(project);
        TaskProvider<Zip> bundleTask = PluginBuildPlugin.createBundleTasks(project, extension);
        project.afterEvaluate(project1 -> {
            PluginBuildPlugin.configurePublishing(project1, extension);
            String name = extension.getName();
            project1.setProperty("archivesBaseName", (Object)name);
            project1.setDescription(extension.getDescription());
            if (extension.getName() == null) {
                throw new InvalidUserDataException("name is a required setting for esplugin");
            }
            if (extension.getDescription() == null) {
                throw new InvalidUserDataException("description is a required setting for esplugin");
            }
            if (!extension.getType().equals((Object)PluginType.BOOTSTRAP) && extension.getClassname() == null) {
                throw new InvalidUserDataException("classname is a required setting for esplugin");
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(12);
            map.put("name", extension.getName());
            map.put("description", extension.getDescription());
            map.put("version", extension.getVersion());
            map.put("elasticsearchVersion", Version.fromString(VersionProperties.getElasticsearch()).toString());
            map.put("javaVersion", ((JavaPluginExtension)project1.getExtensions().getByType(JavaPluginExtension.class)).getTargetCompatibility().toString());
            map.put("classname", extension.getType().equals((Object)PluginType.BOOTSTRAP) ? "" : extension.getClassname());
            map.put("extendedPlugins", extension.getExtendedPlugins().stream().collect(Collectors.joining(",")));
            map.put("hasNativeController", extension.isHasNativeController());
            map.put("requiresKeystore", extension.isRequiresKeystore());
            map.put("type", extension.getType().toString());
            map.put("javaOpts", extension.getJavaOpts());
            map.put("licensed", extension.isLicensed());
            project1.getTasks().withType(Copy.class).named("pluginProperties").configure(copy -> {
                copy.expand(map);
                copy.getInputs().properties(map);
            });
        });
        project.getConfigurations().getByName("default").extendsFrom(new Configuration[]{project.getConfigurations().getByName("runtimeClasspath")});
        NamedDomainObjectContainer<ElasticsearchCluster> testClusters = PluginBuildPlugin.testClusters(project, "testClusters");
        NamedDomainObjectProvider runCluster = testClusters.register("runTask", c -> {
            if (GradleUtils.isModuleProject(project.getPath())) {
                c.module((Provider<RegularFile>)bundleTask.flatMap(zip -> zip.getArchiveFile()));
            } else {
                c.plugin((Provider<RegularFile>)bundleTask.flatMap(zip -> zip.getArchiveFile()));
            }
        });
        project.getTasks().register("run", RunTask.class, r -> {
            r.useCluster((Provider)runCluster);
            r.dependsOn(new Object[]{project.getTasks().named(BUNDLE_PLUGIN_TASK_NAME)});
        });
    }

    private static NamedDomainObjectContainer<ElasticsearchCluster> testClusters(Project project, String extensionName) {
        return (NamedDomainObjectContainer)project.getExtensions().getByName(extensionName);
    }

    private static void configurePublishing(Project project, PluginPropertiesExtension extension) {
        if (project.getPlugins().hasPlugin(MavenPublishPlugin.class)) {
            PublishingExtension publishingExtension = (PublishingExtension)project.getExtensions().getByType(PublishingExtension.class);
            MavenPublication elastic = (MavenPublication)publishingExtension.getPublications().maybeCreate("elastic", MavenPublication.class);
            elastic.setArtifactId(extension.getName());
        }
    }

    private static void configureDependencies(Project project) {
        DependencyHandler dependencies = project.getDependencies();
        dependencies.add("compileOnly", (Object)("org.elasticsearch:elasticsearch:" + VersionProperties.getElasticsearch()));
        dependencies.add("testImplementation", (Object)("org.elasticsearch.test:framework:" + VersionProperties.getElasticsearch()));
        dependencies.add("testImplementation", (Object)("org.apache.logging.log4j:log4j-core:" + VersionProperties.getVersions().get("log4j")));
        dependencies.add("compileOnly", (Object)("org.locationtech.spatial4j:spatial4j:" + VersionProperties.getVersions().get("spatial4j")));
        dependencies.add("compileOnly", (Object)("org.locationtech.jts:jts-core:" + VersionProperties.getVersions().get("jts")));
        dependencies.add("compileOnly", (Object)("org.apache.logging.log4j:log4j-api:" + VersionProperties.getVersions().get("log4j")));
        dependencies.add("compileOnly", (Object)("org.apache.logging.log4j:log4j-core:" + VersionProperties.getVersions().get("log4j")));
        dependencies.add("compileOnly", (Object)("net.java.dev.jna:jna:" + VersionProperties.getVersions().get("jna")));
    }

    private static TaskProvider<Zip> createBundleTasks(Project project, PluginPropertiesExtension extension) {
        File pluginMetadata = project.file((Object)"src/main/plugin-metadata");
        final File templateFile = new File(project.getBuildDir(), "templates/plugin-descriptor.properties");
        TaskProvider copyPluginPropertiesTemplate = project.getTasks().register("copyPluginPropertiesTemplate", (Action)new Action<Task>(){

            public void execute(Task task) {
                task.getOutputs().file((Object)templateFile);
                task.doLast((Action)new Action<Task>(){

                    public void execute(Task task) {
                        InputStream resourceTemplate = PluginBuildPlugin.class.getResourceAsStream("/" + templateFile.getName());
                        try {
                            String templateText = IOUtils.toString((InputStream)resourceTemplate, (String)StandardCharsets.UTF_8.name());
                            FileUtils.write((File)templateFile, (CharSequence)templateText, (String)"UTF-8");
                        }
                        catch (IOException e) {
                            throw new GradleException("Unable to copy plugin properties", (Throwable)e);
                        }
                    }
                });
            }
        });
        TaskProvider buildProperties = project.getTasks().register("pluginProperties", Copy.class, copy -> {
            copy.dependsOn(new Object[]{copyPluginPropertiesTemplate});
            copy.from(new Object[]{templateFile});
            copy.into((Object)new File(project.getBuildDir(), "generated-resources"));
        });
        SourceSet testSourceSet = (SourceSet)((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("test");
        Map<String, TaskProvider> map = Map.of("builtBy", buildProperties);
        testSourceSet.getOutput().dir(map, (Object)new File(project.getBuildDir(), "generated-resources"));
        testSourceSet.getResources().srcDir((Object)pluginMetadata);
        CopySpec bundleSpec = PluginBuildPlugin.createBundleSpec(project, pluginMetadata, (TaskProvider<Copy>)buildProperties);
        extension.setBundleSpec(bundleSpec);
        TaskProvider bundle = project.getTasks().register(BUNDLE_PLUGIN_TASK_NAME, Zip.class, zip -> zip.with(new CopySpec[]{bundleSpec}));
        project.getTasks().named("assemble").configure(task -> task.dependsOn(new Object[]{bundle}));
        Configuration configuration = (Configuration)project.getConfigurations().create("zip");
        configuration.getAttributes().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"zip");
        project.getArtifacts().add("zip", (Object)bundle);
        TaskProvider explodedBundle = project.getTasks().register("explodedBundlePlugin", Sync.class, sync -> {
            sync.with(new CopySpec[]{bundleSpec});
            sync.into((Object)new File(project.getBuildDir(), "explodedBundle"));
        });
        Configuration explodedBundleZip = (Configuration)project.getConfigurations().create(EXPLODED_BUNDLE_CONFIG);
        explodedBundleZip.setCanBeResolved(false);
        explodedBundleZip.setCanBeConsumed(true);
        explodedBundleZip.getAttributes().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"directory");
        project.getArtifacts().add(EXPLODED_BUNDLE_CONFIG, (Object)explodedBundle);
        return bundle;
    }

    private static CopySpec createBundleSpec(Project project, File pluginMetadata, TaskProvider<Copy> buildProperties) {
        CopySpec bundleSpec = project.copySpec();
        bundleSpec.from(new Object[]{buildProperties});
        bundleSpec.from((Object)pluginMetadata, copySpec -> copySpec.exclude(new String[]{"plugin-security.codebases"}));
        bundleSpec.from(new Object[]{() -> project.getPluginManager().hasPlugin("com.github.johnrengelman.shadow") ? project.getTasks().named("shadowJar") : project.getTasks().named("jar")});
        bundleSpec.from(new Object[]{project.getConfigurations().getByName("runtimeClasspath").minus((FileCollection)project.getConfigurations().getByName("resolveableCompileOnly"))});
        bundleSpec.from(new Object[]{"src/main/packaging"});
        bundleSpec.from((Object)"src/main", copySpec -> {
            copySpec.include(new String[]{"config/**"});
            copySpec.include(new String[]{"bin/**"});
        });
        return bundleSpec;
    }
}

