/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.deletebyquery;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.deletebyquery.IndexDeleteByQueryResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class DeleteByQueryResponse
extends ActionResponse
implements ToXContent {
    private long tookInMillis;
    private boolean timedOut = false;
    private long found;
    private long deleted;
    private long missing;
    private long failed;
    private IndexDeleteByQueryResponse[] indices = IndexDeleteByQueryResponse.EMPTY_ARRAY;
    private ShardOperationFailedException[] shardFailures = ShardSearchFailure.EMPTY_ARRAY;

    DeleteByQueryResponse() {
    }

    DeleteByQueryResponse(long tookInMillis, boolean timedOut, long found, long deleted, long missing, long failed, IndexDeleteByQueryResponse[] indices, ShardOperationFailedException[] shardFailures) {
        this.tookInMillis = tookInMillis;
        this.timedOut = timedOut;
        this.found = found;
        this.deleted = deleted;
        this.missing = missing;
        this.failed = failed;
        this.indices = indices;
        this.shardFailures = shardFailures;
    }

    public IndexDeleteByQueryResponse[] getIndices() {
        return this.indices;
    }

    public IndexDeleteByQueryResponse getIndex(String index) {
        if (index == null) {
            return null;
        }
        for (IndexDeleteByQueryResponse i : this.indices) {
            if (!index.equals(i.getIndex())) continue;
            return i;
        }
        return null;
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    public long getTookInMillis() {
        return this.tookInMillis;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public long getTotalFound() {
        return this.found;
    }

    public long getTotalDeleted() {
        return this.deleted;
    }

    public long getTotalMissing() {
        return this.missing;
    }

    public long getTotalFailed() {
        return this.failed;
    }

    public ShardOperationFailedException[] getShardFailures() {
        return this.shardFailures;
    }

    public void readFrom(StreamInput in) throws IOException {
        int i;
        super.readFrom(in);
        this.tookInMillis = in.readVLong();
        this.timedOut = in.readBoolean();
        this.found = in.readVLong();
        this.deleted = in.readVLong();
        this.missing = in.readVLong();
        this.failed = in.readVLong();
        int size = in.readVInt();
        this.indices = new IndexDeleteByQueryResponse[size];
        for (i = 0; i < size; ++i) {
            IndexDeleteByQueryResponse index = new IndexDeleteByQueryResponse();
            index.readFrom(in);
            this.indices[i] = index;
        }
        size = in.readVInt();
        if (size == 0) {
            this.shardFailures = ShardSearchFailure.EMPTY_ARRAY;
        } else {
            this.shardFailures = new ShardSearchFailure[size];
            for (i = 0; i < this.shardFailures.length; ++i) {
                this.shardFailures[i] = ShardSearchFailure.readShardSearchFailure((StreamInput)in);
            }
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.tookInMillis);
        out.writeBoolean(this.timedOut);
        out.writeVLong(this.found);
        out.writeVLong(this.deleted);
        out.writeVLong(this.missing);
        out.writeVLong(this.failed);
        out.writeVInt(this.indices.length);
        for (IndexDeleteByQueryResponse indexDeleteByQueryResponse : this.indices) {
            indexDeleteByQueryResponse.writeTo(out);
        }
        out.writeVInt(this.shardFailures.length);
        for (IndexDeleteByQueryResponse indexDeleteByQueryResponse : this.shardFailures) {
            indexDeleteByQueryResponse.writeTo(out);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Fields.TOOK, this.tookInMillis);
        builder.field(Fields.TIMED_OUT, this.timedOut);
        builder.startObject(Fields.INDICES);
        IndexDeleteByQueryResponse all = new IndexDeleteByQueryResponse("_all", this.found, this.deleted, this.missing, this.failed);
        all.toXContent(builder, params);
        for (IndexDeleteByQueryResponse indexDeleteByQueryResponse : this.indices) {
            indexDeleteByQueryResponse.toXContent(builder, params);
        }
        builder.endObject();
        builder.startArray(Fields.FAILURES);
        if (this.shardFailures != null) {
            for (IndexDeleteByQueryResponse indexDeleteByQueryResponse : this.shardFailures) {
                builder.startObject();
                indexDeleteByQueryResponse.toXContent(builder, params);
                builder.endObject();
            }
        }
        builder.endArray();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString TOOK = new XContentBuilderString("took");
        static final XContentBuilderString TIMED_OUT = new XContentBuilderString("timed_out");
        static final XContentBuilderString INDICES = new XContentBuilderString("_indices");
        static final XContentBuilderString FAILURES = new XContentBuilderString("failures");

        Fields() {
        }
    }
}

