/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.deletebyquery;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class IndexDeleteByQueryResponse
extends ActionResponse
implements ToXContent {
    public static final IndexDeleteByQueryResponse[] EMPTY_ARRAY = new IndexDeleteByQueryResponse[0];
    private String index;
    private long found = 0L;
    private long deleted = 0L;
    private long missing = 0L;
    private long failed = 0L;

    IndexDeleteByQueryResponse() {
    }

    IndexDeleteByQueryResponse(String index) {
        this.index = index;
    }

    public IndexDeleteByQueryResponse(String index, long found, long deleted, long missing, long failed) {
        this(index);
        this.incrementFound(found);
        this.incrementDeleted(deleted);
        this.incrementMissing(missing);
        this.incrementFailed(failed);
    }

    public String getIndex() {
        return this.index;
    }

    public long getFound() {
        return this.found;
    }

    public void incrementFound() {
        this.incrementFound(1L);
    }

    public void incrementFound(long delta) {
        assert (this.found + delta >= 0L) : "counter 'found' cannot be negative";
        this.found += delta;
    }

    public long getDeleted() {
        return this.deleted;
    }

    public void incrementDeleted() {
        this.incrementDeleted(1L);
    }

    public void incrementDeleted(long delta) {
        assert (this.deleted + delta >= 0L) : "counter 'deleted' cannot be negative";
        this.deleted += delta;
    }

    public long getMissing() {
        return this.missing;
    }

    public void incrementMissing() {
        this.incrementMissing(1L);
    }

    public void incrementMissing(long delta) {
        assert (this.missing + delta >= 0L) : "counter 'missing' cannot be negative";
        this.missing += delta;
    }

    public long getFailed() {
        return this.failed;
    }

    public void incrementFailed() {
        this.incrementFailed(1L);
    }

    public void incrementFailed(long delta) {
        assert (this.failed + delta >= 0L) : "counter 'failed' cannot be negative";
        this.failed += delta;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.index = in.readString();
        this.found = in.readVLong();
        this.deleted = in.readVLong();
        this.missing = in.readVLong();
        this.failed = in.readVLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
        out.writeVLong(this.found);
        out.writeVLong(this.deleted);
        out.writeVLong(this.missing);
        out.writeVLong(this.failed);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.index);
        builder.field(Fields.FOUND, this.found);
        builder.field(Fields.DELETED, this.deleted);
        builder.field(Fields.MISSING, this.missing);
        builder.field(Fields.FAILED, this.failed);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString FOUND = new XContentBuilderString("found");
        static final XContentBuilderString DELETED = new XContentBuilderString("deleted");
        static final XContentBuilderString MISSING = new XContentBuilderString("missing");
        static final XContentBuilderString FAILED = new XContentBuilderString("failed");

        Fields() {
        }
    }
}

