/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.javascript;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.LeafSearchScript;
import org.elasticsearch.script.ScoreAccessor;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.script.javascript.support.NativeList;
import org.elasticsearch.script.javascript.support.NativeMap;
import org.elasticsearch.script.javascript.support.ScriptValueConverter;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrapFactory;

public class JavaScriptScriptEngineService
extends AbstractComponent
implements ScriptEngineService {
    private final AtomicLong counter = new AtomicLong();
    private static WrapFactory wrapFactory = new CustomWrapFactory();
    private final int optimizationLevel;
    private Scriptable globalScope;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    public JavaScriptScriptEngineService(Settings settings) {
        super(settings);
        this.optimizationLevel = settings.getAsInt("script.javascript.optimization_level", Integer.valueOf(1));
        Context ctx = Context.enter();
        try {
            ctx.setWrapFactory(wrapFactory);
            this.globalScope = ctx.initStandardObjects(null, true);
        }
        finally {
            Context.exit();
        }
    }

    public void close() {
    }

    public void scriptRemoved(@Nullable CompiledScript compiledScript) {
    }

    public String[] types() {
        return new String[]{"js", "javascript"};
    }

    public String[] extensions() {
        return new String[]{"js"};
    }

    public boolean sandboxed() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object compile(String script) {
        Context ctx = Context.enter();
        try {
            ctx.setWrapFactory(wrapFactory);
            ctx.setOptimizationLevel(this.optimizationLevel);
            Script script2 = ctx.compileString(script, this.generateScriptName(), 1, null);
            return script2;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutableScript executable(CompiledScript compiledScript, Map<String, Object> vars) {
        Context ctx = Context.enter();
        try {
            ctx.setWrapFactory(wrapFactory);
            Scriptable scope = ctx.newObject(this.globalScope);
            scope.setPrototype(this.globalScope);
            scope.setParentScope(null);
            for (Map.Entry<String, Object> entry : vars.entrySet()) {
                ScriptableObject.putProperty((Scriptable)scope, (String)entry.getKey(), (Object)entry.getValue());
            }
            JavaScriptExecutableScript javaScriptExecutableScript = new JavaScriptExecutableScript((Script)compiledScript.compiled(), scope);
            return javaScriptExecutableScript;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchScript search(final CompiledScript compiledScript, final SearchLookup lookup, final @Nullable Map<String, Object> vars) {
        Context ctx = Context.enter();
        try {
            ctx.setWrapFactory(wrapFactory);
            final Scriptable scope = ctx.newObject(this.globalScope);
            scope.setPrototype(this.globalScope);
            scope.setParentScope(null);
            SearchScript searchScript = new SearchScript(){

                public LeafSearchScript getLeafSearchScript(LeafReaderContext context) throws IOException {
                    LeafSearchLookup leafLookup = lookup.getLeafSearchLookup(context);
                    for (Map.Entry entry : leafLookup.asMap().entrySet()) {
                        ScriptableObject.putProperty((Scriptable)scope, (String)((String)entry.getKey()), entry.getValue());
                    }
                    if (vars != null) {
                        for (Map.Entry entry : vars.entrySet()) {
                            ScriptableObject.putProperty((Scriptable)scope, (String)((String)entry.getKey()), entry.getValue());
                        }
                    }
                    return new JavaScriptSearchScript((Script)compiledScript.compiled(), scope, leafLookup);
                }

                public boolean needsScores() {
                    return true;
                }
            };
            return searchScript;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(CompiledScript compiledScript, Map<String, Object> vars) {
        Context ctx = Context.enter();
        ctx.setWrapFactory(wrapFactory);
        try {
            Script script = (Script)compiledScript.compiled();
            Scriptable scope = ctx.newObject(this.globalScope);
            scope.setPrototype(this.globalScope);
            scope.setParentScope(null);
            for (Map.Entry<String, Object> entry : vars.entrySet()) {
                ScriptableObject.putProperty((Scriptable)scope, (String)entry.getKey(), (Object)entry.getValue());
            }
            Object ret = script.exec(ctx, scope);
            Object object = ScriptValueConverter.unwrapValue(ret);
            return object;
        }
        finally {
            Context.exit();
        }
    }

    public Object unwrap(Object value) {
        return ScriptValueConverter.unwrapValue(value);
    }

    private String generateScriptName() {
        return "Script" + this.counter.incrementAndGet() + ".js";
    }

    public static class CustomWrapFactory
    extends WrapFactory {
        public CustomWrapFactory() {
            this.setJavaPrimitiveWrap(false);
        }

        public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class staticType) {
            if (javaObject instanceof Map) {
                return NativeMap.wrap(scope, (Map)javaObject);
            }
            if (javaObject instanceof List) {
                return NativeList.wrap(scope, (List)javaObject, staticType);
            }
            return super.wrapAsJavaObject(cx, scope, javaObject, staticType);
        }
    }

    public static class JavaScriptSearchScript
    implements LeafSearchScript {
        private final Script script;
        private final Scriptable scope;
        private final LeafSearchLookup lookup;

        public JavaScriptSearchScript(Script script, Scriptable scope, LeafSearchLookup lookup) {
            this.script = script;
            this.scope = scope;
            this.lookup = lookup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setScorer(Scorer scorer) {
            Context ctx = Context.enter();
            try {
                ScriptableObject.putProperty((Scriptable)this.scope, (String)"_score", (Object)wrapFactory.wrapAsJavaObject(ctx, this.scope, (Object)new ScoreAccessor(scorer), ScoreAccessor.class));
            }
            finally {
                Context.exit();
            }
        }

        public void setDocument(int doc) {
            this.lookup.setDocument(doc);
        }

        public void setNextVar(String name, Object value) {
            ScriptableObject.putProperty((Scriptable)this.scope, (String)name, (Object)value);
        }

        public void setSource(Map<String, Object> source) {
            this.lookup.source().setSource(source);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() {
            Context ctx = Context.enter();
            try {
                ctx.setWrapFactory(wrapFactory);
                Object object = ScriptValueConverter.unwrapValue(this.script.exec(ctx, this.scope));
                return object;
            }
            finally {
                Context.exit();
            }
        }

        public float runAsFloat() {
            return ((Number)this.run()).floatValue();
        }

        public long runAsLong() {
            return ((Number)this.run()).longValue();
        }

        public double runAsDouble() {
            return ((Number)this.run()).doubleValue();
        }

        public Object unwrap(Object value) {
            return ScriptValueConverter.unwrapValue(value);
        }
    }

    public static class JavaScriptExecutableScript
    implements ExecutableScript {
        private final Script script;
        private final Scriptable scope;

        public JavaScriptExecutableScript(Script script, Scriptable scope) {
            this.script = script;
            this.scope = scope;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() {
            Context ctx = Context.enter();
            try {
                ctx.setWrapFactory(wrapFactory);
                Object object = ScriptValueConverter.unwrapValue(this.script.exec(ctx, this.scope));
                return object;
            }
            finally {
                Context.exit();
            }
        }

        public void setNextVar(String name, Object value) {
            ScriptableObject.putProperty((Scriptable)this.scope, (String)name, (Object)value);
        }

        public Object unwrap(Object value) {
            return ScriptValueConverter.unwrapValue(value);
        }
    }
}

