/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.javascript.support;

import java.util.Iterator;
import java.util.Map;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

public class NativeMap
implements Scriptable,
Wrapper {
    private static final long serialVersionUID = 3664761893203964569L;
    private Map<Object, Object> map;
    private Scriptable parentScope;
    private Scriptable prototype;

    public static NativeMap wrap(Scriptable scope, Map<Object, Object> map) {
        return new NativeMap(scope, map);
    }

    private NativeMap(Scriptable scope, Map<Object, Object> map) {
        this.parentScope = scope;
        this.map = map;
    }

    public Object unwrap() {
        return this.map;
    }

    public String getClassName() {
        return "NativeMap";
    }

    public Object get(String name, Scriptable start) {
        if ("length".equals(name)) {
            return this.map.size();
        }
        return this.map.get(name);
    }

    public Object get(int index, Scriptable start) {
        Object value = null;
        int i = 0;
        Iterator<Object> itrValues = this.map.values().iterator();
        while (i++ <= index && itrValues.hasNext()) {
            value = itrValues.next();
        }
        return value;
    }

    public boolean has(String name, Scriptable start) {
        return this.map.containsKey(name);
    }

    public boolean has(int index, Scriptable start) {
        return index >= 0 && this.map.values().size() > index;
    }

    public void put(String name, Scriptable start, Object value) {
        this.map.put(name, value);
    }

    public void put(int index, Scriptable start, Object value) {
    }

    public void delete(String name) {
        this.map.remove(name);
    }

    public void delete(int index) {
        int i = 0;
        Iterator<Object> itrKeys = this.map.keySet().iterator();
        while (i <= index && itrKeys.hasNext()) {
            Object key = itrKeys.next();
            if (i != index) continue;
            this.map.remove(key);
            break;
        }
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    public void setPrototype(Scriptable prototype) {
        this.prototype = prototype;
    }

    public Scriptable getParentScope() {
        return this.parentScope;
    }

    public void setParentScope(Scriptable parent) {
        this.parentScope = parent;
    }

    public Object[] getIds() {
        return this.map.keySet().toArray();
    }

    public Object getDefaultValue(Class hint) {
        return null;
    }

    public boolean hasInstance(Scriptable value) {
        if (!(value instanceof Wrapper)) {
            return false;
        }
        Object instance = ((Wrapper)value).unwrap();
        return Map.class.isInstance(instance);
    }
}

