/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.gcs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.util.Map;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStoreException;
import org.elasticsearch.common.blobstore.gcs.GoogleCloudStorageBlobStore;
import org.elasticsearch.common.blobstore.support.AbstractBlobContainer;

public class GoogleCloudStorageBlobContainer
extends AbstractBlobContainer {
    private final GoogleCloudStorageBlobStore blobStore;
    private final String path;

    GoogleCloudStorageBlobContainer(BlobPath path, GoogleCloudStorageBlobStore blobStore) {
        super(path);
        this.blobStore = blobStore;
        this.path = path.buildAsString();
    }

    public boolean blobExists(String blobName) {
        try {
            return this.blobStore.blobExists(this.buildKey(blobName));
        }
        catch (Exception e) {
            throw new BlobStoreException("Failed to check if blob [" + blobName + "] exists", (Throwable)e);
        }
    }

    public Map<String, BlobMetaData> listBlobs() throws IOException {
        return this.blobStore.listBlobs(this.path);
    }

    public Map<String, BlobMetaData> listBlobsByPrefix(String prefix) throws IOException {
        return this.blobStore.listBlobsByPrefix(this.path, prefix);
    }

    public InputStream readBlob(String blobName) throws IOException {
        return this.blobStore.readBlob(this.buildKey(blobName));
    }

    public void writeBlob(String blobName, InputStream inputStream, long blobSize) throws IOException {
        if (this.blobExists(blobName)) {
            throw new FileAlreadyExistsException("blob [" + blobName + "] already exists, cannot overwrite");
        }
        this.blobStore.writeBlob(this.buildKey(blobName), inputStream, blobSize);
    }

    public void deleteBlob(String blobName) throws IOException {
        this.blobStore.deleteBlob(this.buildKey(blobName));
    }

    public void move(String sourceBlobName, String targetBlobName) throws IOException {
        this.blobStore.moveBlob(this.buildKey(sourceBlobName), this.buildKey(targetBlobName));
    }

    protected String buildKey(String blobName) {
        assert (blobName != null);
        return this.path + blobName;
    }
}

