/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.repository.gcs;

import com.google.api.client.auth.oauth2.TokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.json.webtoken.JsonWebToken;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.Data;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import java.security.AccessController;
import java.security.Permission;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.gcs.GoogleCloudStorageRepository;
import org.elasticsearch.repositories.gcs.GoogleCloudStorageService;

public class GoogleCloudStoragePlugin
extends Plugin
implements RepositoryPlugin {
    public static final String NAME = "repository-gcs";

    protected GoogleCloudStorageService createStorageService(Environment environment) {
        return new GoogleCloudStorageService.InternalGoogleCloudStorageService(environment);
    }

    public Map<String, Repository.Factory> getRepositories(Environment env) {
        return Collections.singletonMap("gcs", metadata -> new GoogleCloudStorageRepository(metadata, env, this.createStorageService(env)));
    }

    static {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AccessController.doPrivileged(() -> {
            ClassInfo.of(HttpHeaders.class, (boolean)true);
            ClassInfo.of(JsonWebSignature.Header.class, (boolean)false);
            ClassInfo.of(JsonWebToken.Payload.class, (boolean)false);
            ClassInfo.of(TokenRequest.class, (boolean)false);
            ClassInfo.of(TokenResponse.class, (boolean)false);
            ClassInfo.of(GenericJson.class, (boolean)false);
            ClassInfo.of(GenericUrl.class, (boolean)false);
            Data.nullOf(GoogleJsonError.ErrorInfo.class);
            ClassInfo.of(GoogleJsonError.class, (boolean)false);
            Data.nullOf(Bucket.Cors.class);
            ClassInfo.of(Bucket.class, (boolean)false);
            ClassInfo.of(Bucket.Cors.class, (boolean)false);
            ClassInfo.of(Bucket.Lifecycle.class, (boolean)false);
            ClassInfo.of(Bucket.Logging.class, (boolean)false);
            ClassInfo.of(Bucket.Owner.class, (boolean)false);
            ClassInfo.of(Bucket.Versioning.class, (boolean)false);
            ClassInfo.of(Bucket.Website.class, (boolean)false);
            ClassInfo.of(StorageObject.class, (boolean)false);
            ClassInfo.of(StorageObject.Owner.class, (boolean)false);
            ClassInfo.of(Objects.class, (boolean)false);
            ClassInfo.of(Storage.Buckets.Get.class, (boolean)false);
            ClassInfo.of(Storage.Buckets.Insert.class, (boolean)false);
            ClassInfo.of(Storage.Objects.Get.class, (boolean)false);
            ClassInfo.of(Storage.Objects.Insert.class, (boolean)false);
            ClassInfo.of(Storage.Objects.Delete.class, (boolean)false);
            ClassInfo.of(Storage.Objects.Copy.class, (boolean)false);
            ClassInfo.of(Storage.Objects.List.class, (boolean)false);
            return null;
        });
    }
}

