/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.jdbc;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Locale;
import java.util.function.Function;

final class JdbcDateUtils {
    private static final LocalDate EPOCH = LocalDate.of(1970, 1, 1);
    static final DateTimeFormatter ISO_WITH_MILLIS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).appendZoneOrOffsetId().toFormatter(Locale.ROOT);

    private JdbcDateUtils() {
    }

    private static ZonedDateTime asDateTime(String date) {
        return ISO_WITH_MILLIS.parse((CharSequence)date, ZonedDateTime::from);
    }

    static long asMillisSinceEpoch(String date) {
        return JdbcDateUtils.asDateTime(date).toInstant().toEpochMilli();
    }

    static Date asDate(String date) {
        ZonedDateTime zdt = JdbcDateUtils.asDateTime(date);
        return new Date(zdt.toLocalDate().atStartOfDay(zdt.getZone()).toInstant().toEpochMilli());
    }

    static Time asTime(String date) {
        ZonedDateTime zdt = JdbcDateUtils.asDateTime(date);
        return new Time(zdt.toLocalTime().atDate(EPOCH).atZone(zdt.getZone()).toInstant().toEpochMilli());
    }

    static Timestamp asTimestamp(long millisSinceEpoch) {
        return new Timestamp(millisSinceEpoch);
    }

    static Timestamp asTimestamp(String date) {
        return new Timestamp(JdbcDateUtils.asMillisSinceEpoch(date));
    }

    static <R> R asDateTimeField(Object value, Function<String, R> asDateTimeMethod, Function<Long, R> ctor) {
        if (value instanceof String) {
            return asDateTimeMethod.apply((String)value);
        }
        return ctor.apply(((Number)value).longValue());
    }
}

