/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.sql.client.HttpClient;
import org.elasticsearch.xpack.sql.client.Version;
import org.elasticsearch.xpack.sql.jdbc.Cursor;
import org.elasticsearch.xpack.sql.jdbc.DefaultCursor;
import org.elasticsearch.xpack.sql.jdbc.InfoResponse;
import org.elasticsearch.xpack.sql.jdbc.JdbcColumnInfo;
import org.elasticsearch.xpack.sql.jdbc.JdbcConfiguration;
import org.elasticsearch.xpack.sql.jdbc.RequestMeta;
import org.elasticsearch.xpack.sql.jdbc.TypeUtils;
import org.elasticsearch.xpack.sql.proto.ColumnInfo;
import org.elasticsearch.xpack.sql.proto.MainResponse;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.proto.RequestInfo;
import org.elasticsearch.xpack.sql.proto.SqlQueryRequest;
import org.elasticsearch.xpack.sql.proto.SqlQueryResponse;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;

class JdbcHttpClient {
    private final HttpClient httpClient;
    private final JdbcConfiguration conCfg;
    private InfoResponse serverInfo;

    JdbcHttpClient(JdbcConfiguration conCfg) throws SQLException {
        this(conCfg, true);
    }

    JdbcHttpClient(JdbcConfiguration conCfg, boolean checkServer) throws SQLException {
        this.httpClient = new HttpClient(conCfg);
        this.conCfg = conCfg;
        if (checkServer) {
            this.serverInfo = this.fetchServerInfo();
            this.checkServerVersion();
        }
    }

    boolean ping(long timeoutInMs) throws SQLException {
        return this.httpClient.ping(timeoutInMs);
    }

    Cursor query(String sql, List<SqlTypedParamValue> params, RequestMeta meta) throws SQLException {
        int fetch = meta.fetchSize() > 0 ? meta.fetchSize() : this.conCfg.pageSize();
        SqlQueryRequest sqlRequest = new SqlQueryRequest(sql, params, this.conCfg.zoneId(), fetch, TimeValue.timeValueMillis(meta.timeoutInMs()), TimeValue.timeValueMillis(meta.queryTimeoutInMs()), null, null, new RequestInfo(Mode.JDBC), this.conCfg.fieldMultiValueLeniency());
        SqlQueryResponse response = this.httpClient.query(sqlRequest);
        return new DefaultCursor(this, response.cursor(), this.toJdbcColumnInfo(response.columns()), response.rows(), meta);
    }

    Tuple<String, List<List<Object>>> nextPage(String cursor, RequestMeta meta) throws SQLException {
        SqlQueryRequest sqlRequest = new SqlQueryRequest(cursor, TimeValue.timeValueMillis(meta.timeoutInMs()), TimeValue.timeValueMillis(meta.queryTimeoutInMs()), new RequestInfo(Mode.JDBC));
        SqlQueryResponse response = this.httpClient.query(sqlRequest);
        return new Tuple<String, List<List<Object>>>(response.cursor(), response.rows());
    }

    boolean queryClose(String cursor) throws SQLException {
        return this.httpClient.queryClose(cursor, Mode.JDBC);
    }

    InfoResponse serverInfo() throws SQLException {
        if (this.serverInfo == null) {
            this.serverInfo = this.fetchServerInfo();
        }
        return this.serverInfo;
    }

    private InfoResponse fetchServerInfo() throws SQLException {
        MainResponse mainResponse = this.httpClient.serverInfo();
        Version version = Version.fromString(mainResponse.getVersion());
        return new InfoResponse(mainResponse.getClusterName(), version.major, version.minor, version.revision);
    }

    private void checkServerVersion() throws SQLException {
        if (this.serverInfo.majorVersion != Version.CURRENT.major || this.serverInfo.minorVersion != Version.CURRENT.minor || this.serverInfo.revisionVersion != Version.CURRENT.revision) {
            throw new SQLException("This version of the JDBC driver is only compatible with Elasticsearch version " + Version.CURRENT.toString() + ", attempting to connect to a server version " + this.serverInfo.versionString());
        }
    }

    private List<JdbcColumnInfo> toJdbcColumnInfo(List<ColumnInfo> columns) throws SQLException {
        ArrayList<JdbcColumnInfo> cols = new ArrayList<JdbcColumnInfo>(columns.size());
        for (ColumnInfo info : columns) {
            cols.add(new JdbcColumnInfo(info.name(), TypeUtils.of(info.esType()), "", "", "", "", info.displaySize()));
        }
        return cols;
    }
}

