/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import org.elasticsearch.xpack.sql.jdbc.EsType;
import org.elasticsearch.xpack.sql.jdbc.JdbcConfiguration;
import org.elasticsearch.xpack.sql.jdbc.JdbcConnection;
import org.elasticsearch.xpack.sql.jdbc.JdbcParameterMetaData;
import org.elasticsearch.xpack.sql.jdbc.JdbcStatement;
import org.elasticsearch.xpack.sql.jdbc.PreparedQuery;
import org.elasticsearch.xpack.sql.jdbc.TypeConverter;
import org.elasticsearch.xpack.sql.jdbc.TypeUtils;

class JdbcPreparedStatement
extends JdbcStatement
implements PreparedStatement {
    final PreparedQuery query;

    JdbcPreparedStatement(JdbcConnection con, JdbcConfiguration info, String sql) throws SQLException {
        super(con, info);
        this.query = PreparedQuery.prepare(sql);
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkOpen();
        this.executeQuery();
        return true;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkOpen();
        this.initResultSet(this.query.sql(), this.query.params());
        return this.rs;
    }

    @Override
    public int executeUpdate() throws SQLException {
        throw new SQLFeatureNotSupportedException("Writes not supported");
    }

    private void setParam(int parameterIndex, Object value, int sqlType) throws SQLException {
        this.setParam(parameterIndex, value, TypeUtils.of(sqlType));
    }

    private void setParam(int parameterIndex, Object value, EsType type) throws SQLException {
        this.checkOpen();
        if (parameterIndex < 0 || parameterIndex > this.query.paramCount()) {
            throw new SQLException("Invalid parameter index [ " + parameterIndex + "; needs to be between 1 and [" + this.query.paramCount() + "]");
        }
        this.query.setParam(parameterIndex, value, type);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParam(parameterIndex, null, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, 16);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, -6);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, 5);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, 4);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, -5);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setObject(parameterIndex, (Object)Float.valueOf(x), 7);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, 8);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, -5);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, 12);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, -3);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, 93);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, 93);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, 93);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("AsciiStream not supported");
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("UnicodeStream not supported");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("BinaryStream not supported");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkOpen();
        this.query.clearParams();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            this.setParam(parameterIndex, null, EsType.NULL);
            return;
        }
        this.checkKnownUnsupportedTypes(x);
        this.setObject(parameterIndex, x, TypeUtils.of(x.getClass()).getVendorTypeNumber(), 0);
    }

    @Override
    public void addBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("Batching not supported");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("CharacterStream not supported");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rs != null ? this.rs.getMetaData() : null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (cal == null) {
            this.setObject(parameterIndex, (Object)x, 93);
            return;
        }
        if (x == null) {
            this.setNull(parameterIndex, 93);
            return;
        }
        this.setObject(parameterIndex, (Object)new Date(TypeConverter.convertFromCalendarToUTC(x.getTime(), cal)), 93);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (cal == null) {
            this.setObject(parameterIndex, (Object)x, 93);
            return;
        }
        if (x == null) {
            this.setNull(parameterIndex, 93);
            return;
        }
        this.setObject(parameterIndex, (Object)new Time(TypeConverter.convertFromCalendarToUTC(x.getTime(), cal)), 93);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (cal == null) {
            this.setObject(parameterIndex, (Object)x, 93);
            return;
        }
        if (x == null) {
            this.setNull(parameterIndex, 93);
            return;
        }
        this.setObject(parameterIndex, (Object)new Timestamp(TypeConverter.convertFromCalendarToUTC(x.getTime(), cal)), 93);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new JdbcParameterMetaData(this);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new SQLFeatureNotSupportedException("NString not supported");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("NCharacterStream not supported");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.setObject(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Clob not supported");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Blob not supported");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("NClob not supported");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.setObject(parameterIndex, xmlObject);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x, TypeUtils.asSqlType(targetSqlType), scaleOrLength);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x, TypeUtils.of(targetSqlType), targetSqlType.getName());
    }

    private void setObject(int parameterIndex, Object x, EsType dataType, String typeString) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setParam(parameterIndex, null, dataType);
            return;
        }
        this.checkKnownUnsupportedTypes(x);
        if (x instanceof byte[]) {
            if (dataType != EsType.BINARY) {
                throw new SQLFeatureNotSupportedException("Conversion from type [byte[]] to [" + typeString + "] not supported");
            }
            this.setParam(parameterIndex, x, EsType.BINARY);
            return;
        }
        if (x instanceof Timestamp || x instanceof Calendar || x instanceof Date || x instanceof LocalDateTime || x instanceof Time || x instanceof java.util.Date) {
            if (dataType == EsType.DATETIME) {
                java.util.Date dateToSet;
                if (x instanceof Timestamp) {
                    dateToSet = new java.util.Date(((Timestamp)x).getTime());
                } else if (x instanceof Calendar) {
                    dateToSet = ((Calendar)x).getTime();
                } else if (x instanceof Date) {
                    dateToSet = new java.util.Date(((Date)x).getTime());
                } else if (x instanceof LocalDateTime) {
                    LocalDateTime ldt = (LocalDateTime)x;
                    Calendar cal = this.getDefaultCalendar();
                    cal.set(ldt.getYear(), ldt.getMonthValue() - 1, ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond());
                    dateToSet = cal.getTime();
                } else {
                    dateToSet = x instanceof Time ? new java.util.Date(((Time)x).getTime()) : (java.util.Date)x;
                }
                this.setParam(parameterIndex, (Object)dateToSet, dataType);
                return;
            }
            if (TypeUtils.isString(dataType)) {
                this.setParam(parameterIndex, (Object)String.valueOf(x), dataType);
                return;
            }
            throw new SQLFeatureNotSupportedException("Conversion from type [" + x.getClass().getName() + "] to [" + typeString + "] not supported");
        }
        if (x instanceof Boolean || x instanceof Byte || x instanceof Short || x instanceof Integer || x instanceof Long || x instanceof Float || x instanceof Double || x instanceof String) {
            this.setParam(parameterIndex, TypeConverter.convert(x, TypeUtils.of(x.getClass()), TypeUtils.classOf(dataType), typeString), dataType);
            return;
        }
        throw new SQLFeatureNotSupportedException("Conversion from type [" + x.getClass().getName() + "] to [" + typeString + "] not supported");
    }

    private void checkKnownUnsupportedTypes(Object x) throws SQLFeatureNotSupportedException {
        ArrayList<Class> unsupportedTypes = new ArrayList<Class>(Arrays.asList(Struct.class, Array.class, SQLXML.class, RowId.class, Ref.class, Blob.class, NClob.class, Clob.class, LocalDate.class, LocalTime.class, OffsetTime.class, OffsetDateTime.class, URL.class, BigDecimal.class));
        for (Class clazz : unsupportedTypes) {
            if (!clazz.isAssignableFrom(x.getClass())) continue;
            throw new SQLFeatureNotSupportedException("Objects of type [" + clazz.getName() + "] are not supported");
        }
    }

    private Calendar getDefaultCalendar() {
        return Calendar.getInstance(this.cfg.timeZone(), Locale.ROOT);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("AsciiStream not supported");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("BinaryStream not supported");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("CharacterStream not supported");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("AsciiStream not supported");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("BinaryStream not supported");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("CharacterStream not supported");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException("NCharacterStream not supported");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Clob not supported");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Blob not supported");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("NClob not supported");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new SQLException("Forbidden method on PreparedStatement");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new SQLException("Forbidden method on PreparedStatement");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new SQLException("Forbidden method on PreparedStatement");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Forbidden method on PreparedStatement");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Forbidden method on PreparedStatement");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Forbidden method on PreparedStatement");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Forbidden method on PreparedStatement");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Forbidden method on PreparedStatement");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Forbidden method on PreparedStatement");
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        throw new SQLFeatureNotSupportedException("Batching not supported");
    }
}

