/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.xpack.sql.jdbc.Cursor;
import org.elasticsearch.xpack.sql.jdbc.JdbcConfiguration;
import org.elasticsearch.xpack.sql.jdbc.JdbcConnection;
import org.elasticsearch.xpack.sql.jdbc.JdbcResultSet;
import org.elasticsearch.xpack.sql.jdbc.JdbcWrapper;
import org.elasticsearch.xpack.sql.jdbc.RequestMeta;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;

class JdbcStatement
implements Statement,
JdbcWrapper {
    final JdbcConnection con;
    final JdbcConfiguration cfg;
    private boolean closed = false;
    private boolean closeOnCompletion = false;
    private boolean ignoreResultSetClose = false;
    protected JdbcResultSet rs;
    final RequestMeta requestMeta;

    JdbcStatement(JdbcConnection jdbcConnection, JdbcConfiguration info) {
        this.con = jdbcConnection;
        this.cfg = info;
        this.requestMeta = new RequestMeta(info.pageSize(), info.pageTimeout(), info.queryTimeout());
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (!this.execute(sql)) {
            throw new SQLException("Invalid sql query [" + sql + "]");
        }
        return this.rs;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Update not supported");
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            this.closeResultSet();
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkOpen();
        if (max < 0) {
            throw new SQLException("Field size must be positive");
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        long result = this.getLargeMaxRows();
        if (result > Integer.MAX_VALUE) {
            throw new SQLException("Max rows exceeds limit of 2147483647");
        }
        return Math.toIntExact(result);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.checkOpen();
        return 0L;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.setLargeMaxRows(max);
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.checkOpen();
        if (max < 0L) {
            throw new SQLException("Field size must be positive");
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkOpen();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        return (int)TimeUnit.MILLISECONDS.toSeconds(this.requestMeta.queryTimeoutInMs());
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkOpen();
        if (seconds < 0) {
            throw new SQLException("Query timeout must be positive");
        }
        this.requestMeta.queryTimeout(TimeUnit.SECONDS.toMillis(seconds));
    }

    @Override
    public void cancel() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Cancel not supported");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkOpen();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkOpen();
        this.initResultSet(sql, Collections.emptyList());
        return true;
    }

    protected void initResultSet(String sql, List<SqlTypedParamValue> params) throws SQLException {
        this.closeResultSet();
        Cursor cursor = this.con.client.query(sql, params, this.requestMeta);
        this.rs = new JdbcResultSet(this.cfg, this, cursor);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        return this.rs;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        long count = this.getLargeUpdateCount();
        return count > Integer.MAX_VALUE ? Integer.MAX_VALUE : (count < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)count);
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.checkOpen();
        return -1L;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        this.closeResultSet();
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        if (1001 != direction || 1000 != direction || 1002 != direction) {
            throw new SQLException("Invalid direction specified");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        if (rows < 0) {
            throw new SQLException("Fetch size must be positive");
        }
        this.requestMeta.fetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this.requestMeta.fetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkOpen();
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batching not supported");
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batching not supported");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batching not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkOpen();
        return this.con;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkOpen();
        if (1 == current) {
            this.closeResultSet();
            return false;
        }
        if (2 == current || 3 == current) {
            throw new SQLException("Invalid current parameter");
        }
        throw new SQLFeatureNotSupportedException("Multiple ResultSets not supported");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Generated keys not supported");
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batching not supported");
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batching not supported");
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batching not supported");
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batching not supported");
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batching not supported");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batching not supported");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batching not supported");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batching not supported");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkOpen();
        return 2;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkOpen();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkOpen();
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkOpen();
        return this.closeOnCompletion;
    }

    protected final void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is closed");
        }
    }

    protected final void closeResultSet() throws SQLException {
        if (this.rs != null) {
            this.ignoreResultSetClose = true;
            try {
                this.rs.close();
            }
            finally {
                this.rs = null;
                this.ignoreResultSetClose = false;
            }
        }
    }

    final void resultSetWasClosed() throws SQLException {
        if (this.closeOnCompletion && !this.ignoreResultSetClose) {
            this.close();
        }
    }
}

