/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.sql.proto.ProtoUtils;

public class SqlTypedParamValue
implements ToXContentObject {
    private static final ConstructingObjectParser<SqlTypedParamValue, Void> PARSER = new ConstructingObjectParser("params", true, objects -> new SqlTypedParamValue((String)objects[1], objects[0]));
    private static final ParseField VALUE = new ParseField("value", new String[0]);
    private static final ParseField TYPE = new ParseField("type", new String[0]);
    public final Object value;
    public final String type;

    public SqlTypedParamValue(String type, Object value) {
        this.value = value;
        this.type = type;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", this.type);
        builder.field("value", this.value);
        builder.endObject();
        return builder;
    }

    public static SqlTypedParamValue fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlTypedParamValue that = (SqlTypedParamValue)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.type);
    }

    public String toString() {
        return String.valueOf(this.value) + "[" + this.type + "]";
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> ProtoUtils.parseFieldsValue(p), VALUE, ObjectParser.ValueType.VALUE);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TYPE);
    }
}

