/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.elasticsearch.geometry;

import shadow.org.elasticsearch.geometry.Geometry;
import shadow.org.elasticsearch.geometry.GeometryVisitor;
import shadow.org.elasticsearch.geometry.ShapeType;
import shadow.org.elasticsearch.geometry.utils.WellKnownText;

public class Rectangle
implements Geometry {
    public static final Rectangle EMPTY = new Rectangle();
    private final double minY;
    private final double minX;
    private final double minZ;
    private final double maxY;
    private final double maxX;
    private final double maxZ;
    private final boolean empty;

    private Rectangle() {
        this.minY = 0.0;
        this.minX = 0.0;
        this.maxY = 0.0;
        this.maxX = 0.0;
        this.minZ = Double.NaN;
        this.maxZ = Double.NaN;
        this.empty = true;
    }

    public Rectangle(double minX, double maxX, double maxY, double minY) {
        this(minX, maxX, maxY, minY, Double.NaN, Double.NaN);
    }

    public Rectangle(double minX, double maxX, double maxY, double minY, double minZ, double maxZ) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.minZ = minZ;
        this.maxZ = maxZ;
        this.empty = false;
        if (maxY < minY) {
            throw new IllegalArgumentException("max y cannot be less than min y");
        }
        if (Double.isNaN(minZ) != Double.isNaN(maxZ)) {
            throw new IllegalArgumentException("only one z value is specified");
        }
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinZ() {
        return this.minZ;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxZ() {
        return this.maxZ;
    }

    public double getMinLat() {
        return this.minY;
    }

    public double getMinLon() {
        return this.minX;
    }

    public double getMinAlt() {
        return this.minZ;
    }

    public double getMaxLat() {
        return this.maxY;
    }

    public double getMaxLon() {
        return this.maxX;
    }

    public double getMaxAlt() {
        return this.maxZ;
    }

    @Override
    public ShapeType type() {
        return ShapeType.ENVELOPE;
    }

    public String toString() {
        return WellKnownText.toWKT(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rectangle rectangle = (Rectangle)o;
        if (Double.compare(rectangle.minY, this.minY) != 0) {
            return false;
        }
        if (Double.compare(rectangle.minX, this.minX) != 0) {
            return false;
        }
        if (Double.compare(rectangle.maxY, this.maxY) != 0) {
            return false;
        }
        if (Double.compare(rectangle.maxX, this.maxX) != 0) {
            return false;
        }
        if (Double.compare(rectangle.minZ, this.minZ) != 0) {
            return false;
        }
        return Double.compare(rectangle.maxZ, this.maxZ) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.minY);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minZ);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxZ);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public <T, E extends Exception> T visit(GeometryVisitor<T, E> visitor) throws E {
        return visitor.visit(this);
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public boolean hasZ() {
        return !Double.isNaN(this.maxZ);
    }
}

