/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.elasticsearch.xpack.sql.proto;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import shadow.org.elasticsearch.core.Nullable;
import shadow.org.elasticsearch.xcontent.ConstructingObjectParser;
import shadow.org.elasticsearch.xcontent.ObjectParser;
import shadow.org.elasticsearch.xcontent.ParseField;
import shadow.org.elasticsearch.xcontent.XContentParser;
import shadow.org.elasticsearch.xpack.sql.proto.ColumnInfo;
import shadow.org.elasticsearch.xpack.sql.proto.ProtoUtils;

public class SqlQueryResponse {
    public static final ConstructingObjectParser<SqlQueryResponse, Void> PARSER = new ConstructingObjectParser("sql", true, objects -> new SqlQueryResponse(objects[0] == null ? "" : (String)objects[0], (List)objects[1], (List)objects[2], (String)objects[3], objects[4] != null && (Boolean)objects[4] != false, objects[5] != null && (Boolean)objects[5] != false));
    public static final ParseField CURSOR = new ParseField("cursor", new String[0]);
    public static final ParseField COLUMNS = new ParseField("columns", new String[0]);
    public static final ParseField ROWS = new ParseField("rows", new String[0]);
    public static final ParseField ID = new ParseField("id", new String[0]);
    public static final ParseField IS_PARTIAL = new ParseField("is_partial", new String[0]);
    public static final ParseField IS_RUNNING = new ParseField("is_running", new String[0]);
    private final String cursor;
    private final List<ColumnInfo> columns;
    private final List<List<Object>> rows;
    @Nullable
    private final String asyncExecutionId;
    private final boolean isPartial;
    private final boolean isRunning;

    public SqlQueryResponse(String cursor, @Nullable List<ColumnInfo> columns, List<List<Object>> rows) {
        this(cursor, columns, rows, null, false, false);
    }

    public SqlQueryResponse(String cursor, @Nullable List<ColumnInfo> columns, List<List<Object>> rows, String asyncExecutionId, boolean isPartial, boolean isRunning) {
        this.cursor = cursor;
        this.columns = columns;
        this.rows = rows;
        this.asyncExecutionId = asyncExecutionId;
        this.isPartial = isPartial;
        this.isRunning = isRunning;
    }

    public String cursor() {
        return this.cursor;
    }

    public long size() {
        return this.rows.size();
    }

    public List<ColumnInfo> columns() {
        return this.columns;
    }

    public List<List<Object>> rows() {
        return this.rows;
    }

    public String id() {
        return this.asyncExecutionId;
    }

    public boolean isPartial() {
        return this.isPartial;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public static SqlQueryResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public static List<List<Object>> parseRows(XContentParser parser) throws IOException {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                list.add(SqlQueryResponse.parseRow(parser));
                continue;
            }
            throw new IllegalStateException("expected start array but got [" + (Object)((Object)parser.currentToken()) + "]");
        }
        return list;
    }

    public static List<Object> parseRow(XContentParser parser) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            if (parser.currentToken().isValue()) {
                list.add(ProtoUtils.parseFieldsValue(parser));
                continue;
            }
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                list.add(null);
                continue;
            }
            throw new IllegalStateException("expected value but got [" + (Object)((Object)parser.currentToken()) + "]");
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlQueryResponse that = (SqlQueryResponse)o;
        return Objects.equals(this.cursor, that.cursor) && Objects.equals(this.columns, that.columns) && Objects.equals(this.rows, that.rows) && Objects.equals(this.asyncExecutionId, that.asyncExecutionId) && this.isPartial == that.isPartial && this.isRunning == that.isRunning;
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.columns, this.rows, this.asyncExecutionId, this.isPartial, this.isRunning);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), CURSOR);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ColumnInfo.fromXContent(p), COLUMNS);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> SqlQueryResponse.parseRows(p), ROWS, ObjectParser.ValueType.OBJECT_ARRAY);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ID);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), IS_PARTIAL);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), IS_RUNNING);
    }
}

