/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.jdbc;

import java.net.URI;
import java.net.URLDecoder;
import java.sql.DriverPropertyInfo;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.xpack.sql.jdbc.JdbcSQLException;
import shadow.org.elasticsearch.xpack.sql.client.ClientVersion;
import shadow.org.elasticsearch.xpack.sql.client.ConnectionConfiguration;
import shadow.org.elasticsearch.xpack.sql.client.StringUtils;
import shadow.org.elasticsearch.xpack.sql.client.UriUtils;

public class JdbcConfiguration
extends ConnectionConfiguration {
    static final String URL_PREFIX = "jdbc:es://";
    static final String URL_FULL_PREFIX = "jdbc:elasticsearch://";
    public static URI DEFAULT_URI = URI.create("http://localhost:9200/");
    static final String DEBUG = "debug";
    static final String DEBUG_DEFAULT = "false";
    static final String DEBUG_OUTPUT = "debug.output";
    static final String DEBUG_OUTPUT_DEFAULT = "err";
    static final String DEBUG_FLUSH_ALWAYS = "debug.flushAlways";
    static final String DEBUG_FLUSH_ALWAYS_DEFAULT = "false";
    public static final String TIME_ZONE = "timezone";
    static final String TIME_ZONE_DEFAULT = TimeZone.getDefault().getID();
    public static final String CATALOG = "catalog";
    static final String FIELD_MULTI_VALUE_LENIENCY = "field.multi.value.leniency";
    static final String FIELD_MULTI_VALUE_LENIENCY_DEFAULT = "true";
    static final String INDEX_INCLUDE_FROZEN = "index.include.frozen";
    static final String INDEX_INCLUDE_FROZEN_DEFAULT = "false";
    private static final Set<String> OPTION_NAMES = new LinkedHashSet<String>(Arrays.asList("timezone", "catalog", "field.multi.value.leniency", "index.include.frozen", "debug", "debug.output", "debug.flushAlways"));
    private final boolean debug;
    private final String debugOut;
    private final boolean flushAlways;
    private final ZoneId zoneId;
    private final String catalog;
    private final boolean fieldMultiValueLeniency;
    private final boolean includeFrozen;

    public static JdbcConfiguration create(String u, Properties props, int loginTimeoutSeconds) throws JdbcSQLException {
        URI uri = JdbcConfiguration.parseUrl(u);
        Properties urlProps = JdbcConfiguration.parseProperties(uri, u);
        uri = UriUtils.removeQuery(uri, u, DEFAULT_URI);
        if (props != null) {
            urlProps.putAll((Map<?, ?>)props);
        }
        if (loginTimeoutSeconds > 0) {
            urlProps.setProperty("connect.timeout", Long.toString(TimeUnit.SECONDS.toMillis(loginTimeoutSeconds)));
        }
        try {
            return new JdbcConfiguration(uri, u, urlProps);
        }
        catch (JdbcSQLException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new JdbcSQLException(ex, ex.getMessage());
        }
    }

    private static URI parseUrl(String u) throws JdbcSQLException {
        if (!JdbcConfiguration.canAccept(u)) {
            throw new JdbcSQLException("Expected [jdbc:es://] url, received [" + u + "]");
        }
        try {
            return UriUtils.parseURI(JdbcConfiguration.removeJdbcPrefix(u), DEFAULT_URI);
        }
        catch (IllegalArgumentException ex) {
            String format = "jdbc:[es|elasticsearch]://[[http|https]://]?[host[:port]]?/[prefix]?[\\?[option=value]&]*";
            throw new JdbcSQLException(ex, "Invalid URL: " + ex.getMessage() + "; format should be [" + "jdbc:[es|elasticsearch]://[[http|https]://]?[host[:port]]?/[prefix]?[\\?[option=value]&]*" + "]");
        }
    }

    private static String removeJdbcPrefix(String connectionString) throws JdbcSQLException {
        if (connectionString.startsWith(URL_PREFIX)) {
            return connectionString.substring(URL_PREFIX.length());
        }
        if (connectionString.startsWith(URL_FULL_PREFIX)) {
            return connectionString.substring(URL_FULL_PREFIX.length());
        }
        throw new JdbcSQLException("Expected [jdbc:es://] url, received [" + connectionString + "]");
    }

    private static Properties parseProperties(URI uri, String u) throws JdbcSQLException {
        Properties props = new Properties();
        try {
            if (uri.getRawQuery() != null) {
                List<String> prms = StringUtils.tokenize(uri.getRawQuery(), "&");
                for (String param : prms) {
                    List<String> args = StringUtils.tokenize(param, "=");
                    if (args.size() != 2) {
                        throw new JdbcSQLException("Invalid parameter [" + param + "], format needs to be key=value");
                    }
                    String key = URLDecoder.decode(args.get(0), "UTF-8").trim();
                    String val = URLDecoder.decode(args.get(1), "UTF-8");
                    props.setProperty(key, val);
                }
            }
        }
        catch (JdbcSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse acceptable jdbc url [" + u + "]", e);
        }
        return props;
    }

    private JdbcConfiguration(URI baseURI, String u, Properties props) throws JdbcSQLException {
        super(baseURI, u, props);
        this.debug = this.parseValue(DEBUG, props.getProperty(DEBUG, "false"), Boolean::parseBoolean);
        this.debugOut = props.getProperty(DEBUG_OUTPUT, DEBUG_OUTPUT_DEFAULT);
        this.flushAlways = this.parseValue(DEBUG_FLUSH_ALWAYS, props.getProperty(DEBUG_FLUSH_ALWAYS, "false"), Boolean::parseBoolean);
        this.zoneId = this.parseValue(TIME_ZONE, props.getProperty(TIME_ZONE, TIME_ZONE_DEFAULT), s -> TimeZone.getTimeZone(s).toZoneId().normalized());
        this.catalog = props.getProperty(CATALOG);
        this.fieldMultiValueLeniency = this.parseValue(FIELD_MULTI_VALUE_LENIENCY, props.getProperty(FIELD_MULTI_VALUE_LENIENCY, FIELD_MULTI_VALUE_LENIENCY_DEFAULT), Boolean::parseBoolean);
        this.includeFrozen = this.parseValue(INDEX_INCLUDE_FROZEN, props.getProperty(INDEX_INCLUDE_FROZEN, "false"), Boolean::parseBoolean);
    }

    @Override
    protected Collection<String> extraOptions() {
        return OPTION_NAMES;
    }

    ZoneId zoneId() {
        return this.zoneId;
    }

    public boolean debug() {
        return this.debug;
    }

    public String debugOut() {
        return this.debugOut;
    }

    public boolean flushAlways() {
        return this.flushAlways;
    }

    public TimeZone timeZone() {
        return this.zoneId != null ? TimeZone.getTimeZone(this.zoneId) : null;
    }

    String catalog() {
        return this.catalog;
    }

    public boolean fieldMultiValueLeniency() {
        return this.fieldMultiValueLeniency;
    }

    public boolean indexIncludeFrozen() {
        return this.includeFrozen;
    }

    public static boolean canAccept(String url) {
        String u = url.trim();
        return StringUtils.hasText(u) && (u.startsWith(URL_PREFIX) || u.startsWith(URL_FULL_PREFIX));
    }

    public DriverPropertyInfo[] driverPropertyInfo() {
        ArrayList<DriverPropertyInfo> info = new ArrayList<DriverPropertyInfo>();
        for (String option : this.optionNames()) {
            DriverPropertyInfo prop = new DriverPropertyInfo(option, null);
            info.add(prop);
        }
        return info.toArray(new DriverPropertyInfo[info.size()]);
    }

    static {
        ClientVersion.CURRENT.toString();
    }
}

