/*
 * Decompiled with CFR 0.152.
 */
package hdfs;

import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.UserGroupInformation;

public class MiniHDFS {
    private static String PORT_FILE_NAME = "ports";
    private static String PID_FILE_NAME = "pid";

    public static void main(String[] args) throws Exception {
        if (args.length != 1 && args.length != 3) {
            throw new IllegalArgumentException("Expected: MiniHDFS <baseDirectory> [<kerberosPrincipal> <kerberosKeytab>], got: " + Arrays.toString(args));
        }
        boolean secure = args.length == 3;
        java.nio.file.Path baseDir = Paths.get(args[0], new String[0]);
        if (System.getenv("HADOOP_HOME") == null) {
            java.nio.file.Path hadoopHome = baseDir.resolve("hadoop-home");
            Files.createDirectories(hadoopHome, new FileAttribute[0]);
            System.setProperty("hadoop.home.dir", hadoopHome.toAbsolutePath().toString());
        }
        java.nio.file.Path hdfsHome = baseDir.resolve("hdfs-data");
        Configuration cfg = new Configuration();
        cfg.set("hdfs.minidfs.basedir", hdfsHome.toAbsolutePath().toString());
        cfg.set("dfs.datanode.data.dir.perm", "766");
        if (secure) {
            String kerberosPrincipal = args[1];
            String keytabFile = args[2];
            cfg.set("hadoop.security.authentication", "kerberos");
            cfg.set("hadoop.security.authorization", "true");
            cfg.set("dfs.namenode.kerberos.principal", kerberosPrincipal);
            cfg.set("dfs.datanode.kerberos.principal", kerberosPrincipal);
            cfg.set("dfs.web.authentication.kerberos.principal", kerberosPrincipal);
            cfg.set("dfs.namenode.keytab.file", keytabFile);
            cfg.set("dfs.datanode.keytab.file", keytabFile);
            cfg.set("dfs.namenode.acls.enabled", "true");
            cfg.set("dfs.block.access.token.enable", "true");
            cfg.set("ignore.secure.ports.for.testing", "true");
        }
        UserGroupInformation.setConfiguration((Configuration)cfg);
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(cfg);
        if (secure) {
            builder.nameNodePort(9998);
        } else {
            builder.nameNodePort(9999);
        }
        MiniDFSCluster dfs = builder.build();
        if (UserGroupInformation.isSecurityEnabled()) {
            DistributedFileSystem fs = dfs.getFileSystem();
            Path esUserPath = new Path("/user/elasticsearch");
            fs.mkdirs(esUserPath);
            ArrayList<AclEntry> acls = new ArrayList<AclEntry>();
            acls.add(new AclEntry.Builder().setType(AclEntryType.USER).setName("elasticsearch").setPermission(FsAction.ALL).build());
            fs.modifyAclEntries(esUserPath, acls);
            fs.close();
        }
        java.nio.file.Path tmp = Files.createTempFile(baseDir, null, null, new FileAttribute[0]);
        String pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        Files.write(tmp, pid.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.move(tmp, baseDir.resolve(PID_FILE_NAME), StandardCopyOption.ATOMIC_MOVE);
        tmp = Files.createTempFile(baseDir, null, null, new FileAttribute[0]);
        Files.write(tmp, Integer.toString(dfs.getNameNodePort()).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.move(tmp, baseDir.resolve(PORT_FILE_NAME), StandardCopyOption.ATOMIC_MOVE);
    }
}

