/*
 * Decompiled with CFR 0.152.
 */
package hdfs;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.security.UserGroupInformation;

public class MiniHDFS {
    private static String PORT_FILE_NAME = "ports";
    private static String PID_FILE_NAME = "pid";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        DistributedFileSystem fs;
        boolean haEnabled;
        if (args.length != 1 && args.length != 3) {
            throw new IllegalArgumentException("Expected: MiniHDFS <baseDirectory> [<kerberosPrincipal> <kerberosKeytab>], got: " + Arrays.toString(args));
        }
        boolean secure = args.length == 3;
        java.nio.file.Path baseDir = Paths.get(args[0], new String[0]);
        if (System.getenv("HADOOP_HOME") == null) {
            java.nio.file.Path hadoopHome = baseDir.resolve("hadoop-home");
            Files.createDirectories(hadoopHome, new FileAttribute[0]);
            System.setProperty("hadoop.home.dir", hadoopHome.toAbsolutePath().toString());
        }
        java.nio.file.Path hdfsHome = baseDir.resolve("hdfs-data");
        Configuration cfg = new Configuration();
        cfg.set("hdfs.minidfs.basedir", hdfsHome.toAbsolutePath().toString());
        cfg.set("dfs.datanode.data.dir.perm", "766");
        if (secure) {
            String kerberosPrincipal = args[1];
            String keytabFile = args[2];
            cfg.set("hadoop.security.authentication", "kerberos");
            cfg.set("hadoop.security.authorization", "true");
            cfg.set("dfs.namenode.kerberos.principal", kerberosPrincipal);
            cfg.set("dfs.datanode.kerberos.principal", kerberosPrincipal);
            cfg.set("dfs.web.authentication.kerberos.principal", kerberosPrincipal);
            cfg.set("dfs.namenode.keytab.file", keytabFile);
            cfg.set("dfs.datanode.keytab.file", keytabFile);
            cfg.set("dfs.namenode.acls.enabled", "true");
            cfg.set("dfs.block.access.token.enable", "true");
            cfg.set("ignore.secure.ports.for.testing", "true");
            cfg.set("dfs.encrypt.data.transfer", "true");
        }
        UserGroupInformation.setConfiguration((Configuration)cfg);
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(cfg);
        if (secure) {
            builder.nameNodePort(9998);
        } else {
            builder.nameNodePort(9999);
        }
        String haNameService = System.getProperty("ha-nameservice");
        boolean bl = haEnabled = haNameService != null;
        if (haEnabled) {
            MiniDFSNNTopology.NNConf nn1 = new MiniDFSNNTopology.NNConf("nn1").setIpcPort(10001);
            MiniDFSNNTopology.NNConf nn2 = new MiniDFSNNTopology.NNConf("nn2").setIpcPort(10002);
            MiniDFSNNTopology.NSConf nameservice = new MiniDFSNNTopology.NSConf(haNameService).addNN(nn1).addNN(nn2);
            MiniDFSNNTopology namenodeTopology = new MiniDFSNNTopology().addNameservice(nameservice);
            builder.nnTopology(namenodeTopology);
        }
        MiniDFSCluster dfs = builder.build();
        Path esUserPath = new Path("/user/elasticsearch");
        if (haEnabled) {
            dfs.transitionToActive(0);
            fs = HATestUtil.configureFailoverFs((MiniDFSCluster)dfs, (Configuration)cfg);
        } else {
            fs = dfs.getFileSystem();
        }
        try {
            fs.mkdirs(esUserPath);
            if (UserGroupInformation.isSecurityEnabled()) {
                ArrayList<AclEntry> acls = new ArrayList<AclEntry>();
                acls.add(new AclEntry.Builder().setType(AclEntryType.USER).setName("elasticsearch").setPermission(FsAction.ALL).build());
                fs.modifyAclEntries(esUserPath, acls);
            }
            String directoryName = "readonly-repository";
            String archiveName = directoryName + ".tar.gz";
            URL readOnlyRepositoryArchiveURL = MiniHDFS.class.getClassLoader().getResource(archiveName);
            if (readOnlyRepositoryArchiveURL != null) {
                java.nio.file.Path tempDirectory = Files.createTempDirectory(MiniHDFS.class.getName(), new FileAttribute[0]);
                File readOnlyRepositoryArchive = tempDirectory.resolve(archiveName).toFile();
                FileUtils.copyURLToFile((URL)readOnlyRepositoryArchiveURL, (File)readOnlyRepositoryArchive);
                FileUtil.unTar((File)readOnlyRepositoryArchive, (File)tempDirectory.toFile());
                fs.copyFromLocalFile(true, true, new Path(tempDirectory.resolve(directoryName).toAbsolutePath().toUri()), esUserPath.suffix("/existing/" + directoryName));
                FileUtils.deleteDirectory((File)tempDirectory.toFile());
            }
        }
        finally {
            fs.close();
        }
        java.nio.file.Path tmp = Files.createTempFile(baseDir, null, null, new FileAttribute[0]);
        String pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        Files.write(tmp, pid.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.move(tmp, baseDir.resolve(PID_FILE_NAME), StandardCopyOption.ATOMIC_MOVE);
        String portFileContent = Integer.toString(dfs.getNameNodePort(0));
        if (haEnabled) {
            portFileContent = portFileContent + "\n" + Integer.toString(dfs.getNameNodePort(1));
        }
        tmp = Files.createTempFile(baseDir, null, null, new FileAttribute[0]);
        Files.write(tmp, portFileContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.move(tmp, baseDir.resolve(PORT_FILE_NAME), StandardCopyOption.ATOMIC_MOVE);
    }
}

