/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.cassandra.common.serialization;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import org.elasticsoftware.elasticactors.serialization.Serializer;

public final class CompressingSerializer<I>
implements Serializer<I, ByteBuffer> {
    private static final LZ4Compressor lz4Compressor = LZ4Factory.fastestJavaInstance().fastCompressor();
    private static final byte[] MAGIC_HEADER = new byte[]{24, 77, 34, 4};
    private final Serializer<I, byte[]> delegate;
    private final int compressionThreshold;

    public CompressingSerializer(Serializer<I, byte[]> delegate) {
        this(delegate, 2048);
    }

    public CompressingSerializer(Serializer<I, byte[]> delegate, int compressionThreshold) {
        this.delegate = delegate;
        this.compressionThreshold = compressionThreshold;
    }

    public ByteBuffer serialize(I object) throws IOException {
        byte[] serializedObject = (byte[])this.delegate.serialize(object);
        if (serializedObject.length > this.compressionThreshold) {
            byte[] compressedBytes = lz4Compressor.compress(serializedObject);
            ByteArrayDataOutput dataOutput = ByteStreams.newDataOutput((int)(compressedBytes.length + 8));
            dataOutput.write(MAGIC_HEADER);
            dataOutput.writeInt(serializedObject.length);
            dataOutput.write(compressedBytes);
            return ByteBuffer.wrap(dataOutput.toByteArray());
        }
        return ByteBuffer.wrap(serializedObject);
    }
}

