/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.cassandra.common.serialization;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.elasticsoftware.elasticactors.serialization.Deserializer;
import org.elasticsoftware.elasticactors.util.ByteBufferUtils;

public final class DecompressingDeserializer<O>
implements Deserializer<ByteBuffer, O> {
    private static final LZ4FastDecompressor lz4Decompressor = LZ4Factory.fastestJavaInstance().fastDecompressor();
    private static final byte[] MAGIC_HEADER = new byte[]{24, 77, 34, 4};
    private final Deserializer<ByteBuffer, O> delegate;

    public DecompressingDeserializer(Deserializer<ByteBuffer, O> delegate) {
        this.delegate = delegate;
    }

    public O deserialize(ByteBuffer serializedBuffer) throws IOException {
        if (DecompressingDeserializer.isCompressed(serializedBuffer)) {
            ByteBuffer uncompressed = (ByteBuffer)ByteBufferUtils.doAndReset((ByteBuffer)serializedBuffer, DecompressingDeserializer::uncompress);
            return (O)this.delegate.deserialize((Object)uncompressed);
        }
        return (O)this.delegate.deserialize((Object)serializedBuffer);
    }

    public boolean isSafe() {
        return this.delegate.isSafe();
    }

    private static int getUncompressedLength(ByteBuffer buffer) {
        buffer.position(MAGIC_HEADER.length);
        return buffer.getInt();
    }

    private static ByteBuffer uncompress(ByteBuffer buffer) {
        int uncompressedLength = ByteBufferUtils.toIntAndReset((ByteBuffer)buffer, DecompressingDeserializer::getUncompressedLength);
        ByteBuffer destination = ByteBuffer.allocate(uncompressedLength);
        lz4Decompressor.decompress(buffer, MAGIC_HEADER.length + 4, destination, 0, uncompressedLength);
        destination.rewind();
        return destination;
    }

    private static boolean isCompressed(byte[] bytes) {
        if (bytes.length < MAGIC_HEADER.length) {
            return false;
        }
        for (int i = 0; i < MAGIC_HEADER.length; ++i) {
            if (bytes[i] == MAGIC_HEADER[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean isCompressed(ByteBuffer bytes) {
        if (bytes.hasArray()) {
            return DecompressingDeserializer.isCompressed(bytes.array());
        }
        if (bytes.remaining() < MAGIC_HEADER.length) {
            return false;
        }
        return ByteBufferUtils.testAndReset((ByteBuffer)bytes, DecompressingDeserializer::isCompressedBuffer);
    }

    private static boolean isCompressedBuffer(ByteBuffer copy) {
        for (byte b : MAGIC_HEADER) {
            if (b == copy.get()) continue;
            return false;
        }
        return true;
    }
}

