/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.cassandra.common.state;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.elasticsoftware.elasticactors.ShardKey;
import org.elasticsoftware.elasticactors.messaging.InternalMessage;
import org.elasticsoftware.elasticactors.messaging.MessageHandlerEventListener;
import org.elasticsoftware.elasticactors.util.concurrent.ThreadBoundEvent;

public final class PersistentActorUpdateEvent
implements ThreadBoundEvent<Integer> {
    private final String[] rowKey;
    private final ShardKey shardKey;
    private final String persistentActorId;
    private final ByteBuffer persistentActorBytes;
    private final InternalMessage message;
    private final MessageHandlerEventListener eventListener;

    public PersistentActorUpdateEvent(String[] rowKey, ShardKey shardKey, String persistentActorId, @Nullable ByteBuffer persistentActorBytes, @Nullable InternalMessage message, @Nullable MessageHandlerEventListener eventListener) {
        this.rowKey = rowKey;
        this.shardKey = shardKey;
        this.persistentActorId = persistentActorId;
        this.persistentActorBytes = persistentActorBytes;
        this.message = message;
        this.eventListener = eventListener;
    }

    public Integer getKey() {
        return this.shardKey.getShardId();
    }

    public String[] getRowKey() {
        return this.rowKey;
    }

    public ShardKey getShardKey() {
        return this.shardKey;
    }

    public String getPersistentActorId() {
        return this.persistentActorId;
    }

    public boolean hasPersistentActorBytes() {
        return this.persistentActorBytes != null;
    }

    @Nullable
    public ByteBuffer getPersistentActorBytes() {
        return this.persistentActorBytes != null ? this.persistentActorBytes.duplicate() : null;
    }

    @Nullable
    public InternalMessage getMessage() {
        return this.message;
    }

    @Nullable
    public MessageHandlerEventListener getEventListener() {
        return this.eventListener;
    }
}

