/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.cassandra2.cluster;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.ShardKey;
import org.elasticsoftware.elasticactors.cassandra2.util.ExecutionUtils;
import org.elasticsoftware.elasticactors.cluster.ActorSystemEvent;
import org.elasticsoftware.elasticactors.cluster.ActorSystemEventListener;
import org.elasticsoftware.elasticactors.cluster.ActorSystemEventListenerRepository;
import org.elasticsoftware.elasticactors.serialization.internal.ActorSystemEventListenerDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.ActorSystemEventListenerSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CassandraActorSystemEventListenerRepository
implements ActorSystemEventListenerRepository {
    private static final Logger logger = LoggerFactory.getLogger(CassandraActorSystemEventListenerRepository.class);
    public static final String INSERT_QUERY = "INSERT INTO \"ActorSystemEventListeners\" (key, key2, key3, column1, value) VALUES (?, ?, ?, ?, ?)";
    public static final String DELETE_QUERY = "DELETE FROM \"ActorSystemEventListeners\" WHERE key = ? AND key2 = ? AND key3 = ? AND column1 = ?";
    public static final String SELECT_QUERY = "SELECT value FROM \"ActorSystemEventListeners\" WHERE key = ? and key2 = ? and key3 = ?";
    private final String clusterName;
    private final Session cassandraSession;
    private final PreparedStatement insertStatement;
    private final PreparedStatement deleteStatement;
    private final PreparedStatement selectStatement;

    public CassandraActorSystemEventListenerRepository(String clusterName, Session cassandraSession) {
        this.clusterName = clusterName;
        this.cassandraSession = cassandraSession;
        this.insertStatement = cassandraSession.prepare(INSERT_QUERY);
        this.deleteStatement = cassandraSession.prepare(DELETE_QUERY);
        this.selectStatement = cassandraSession.prepare(SELECT_QUERY);
    }

    public void create(ShardKey shardKey, ActorSystemEvent event, ActorSystemEventListener listener) {
        byte[] value = ActorSystemEventListenerSerializer.get().serialize(listener);
        ExecutionUtils.executeWithRetry(this.cassandraSession, (Statement)this.insertStatement.bind(new Object[]{this.clusterName, shardKey.toString(), event.name(), listener.getActorId(), ByteBuffer.wrap(value)}), logger);
    }

    public void delete(ShardKey shardKey, ActorSystemEvent event, ActorRef listenerId) {
        ExecutionUtils.executeWithRetry(this.cassandraSession, (Statement)this.deleteStatement.bind(new Object[]{this.clusterName, shardKey.toString(), event.name(), listenerId.getActorId()}), logger);
    }

    public List<ActorSystemEventListener> getAll(ShardKey shardKey, ActorSystemEvent event) {
        ResultSet resultSet = ExecutionUtils.executeWithRetry(this.cassandraSession, this.selectStatement.bind(new Object[]{this.clusterName, shardKey.toString(), event.name()}).setFetchSize(Integer.MAX_VALUE), logger);
        LinkedList<ActorSystemEventListener> resultList = new LinkedList<ActorSystemEventListener>();
        for (Row resultRow : resultSet) {
            for (int i = 0; i < resultRow.getColumnDefinitions().size(); ++i) {
                ByteBuffer resultBuffer = resultRow.getBytes(i);
                byte[] resultBytes = new byte[resultBuffer.remaining()];
                resultBuffer.get(resultBytes);
                try {
                    resultList.add(ActorSystemEventListenerDeserializer.get().deserialize(resultBytes));
                    continue;
                }
                catch (IOException e) {
                    logger.error("IOException while deserializing ActorSystemEventListener", (Throwable)e);
                }
            }
        }
        return resultList;
    }
}

