/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.configuration;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.policies.ConstantReconnectionPolicy;
import com.datastax.driver.core.policies.DefaultRetryPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.LoggingRetryPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.elasticsoftware.elasticactors.cassandra.common.serialization.CompressingSerializer;
import org.elasticsoftware.elasticactors.cassandra.common.serialization.DecompressingDeserializer;
import org.elasticsoftware.elasticactors.cassandra2.cluster.CassandraActorSystemEventListenerRepository;
import org.elasticsoftware.elasticactors.cassandra2.cluster.scheduler.CassandraScheduledMessageRepository;
import org.elasticsoftware.elasticactors.cassandra2.health.CassandraHealthCheck;
import org.elasticsoftware.elasticactors.cassandra2.state.CassandraPersistentActorRepository;
import org.elasticsoftware.elasticactors.cassandra2.state.PersistentActorUpdateEventProcessor;
import org.elasticsoftware.elasticactors.cluster.ActorRefFactory;
import org.elasticsoftware.elasticactors.cluster.ActorSystemEventListenerRepository;
import org.elasticsoftware.elasticactors.cluster.InternalActorSystems;
import org.elasticsoftware.elasticactors.cluster.scheduler.ScheduledMessageRepository;
import org.elasticsoftware.elasticactors.serialization.Deserializer;
import org.elasticsoftware.elasticactors.serialization.SerializationFrameworks;
import org.elasticsoftware.elasticactors.serialization.Serializer;
import org.elasticsoftware.elasticactors.serialization.internal.ActorRefDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.PersistentActorDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.PersistentActorSerializer;
import org.elasticsoftware.elasticactors.serialization.internal.ScheduledMessageDeserializer;
import org.elasticsoftware.elasticactors.state.PersistentActorRepository;
import org.elasticsoftware.elasticactors.util.concurrent.DaemonThreadFactory;
import org.elasticsoftware.elasticactors.util.concurrent.ThreadBoundEventProcessor;
import org.elasticsoftware.elasticactors.util.concurrent.ThreadBoundExecutor;
import org.elasticsoftware.elasticactors.util.concurrent.ThreadBoundExecutorImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class BackplaneConfiguration {
    @Autowired
    private Environment env;
    @Autowired
    private InternalActorSystems cluster;
    @Autowired
    private ActorRefFactory actorRefFactory;
    private Session cassandraSession;

    @PostConstruct
    public void initialize() {
        String cassandraHosts = this.env.getProperty("ea.cassandra.hosts", "localhost:9042");
        String cassandraClusterName = this.env.getProperty("ea.cassandra.cluster", "ElasticActorsCluster");
        String cassandraKeyspaceName = this.env.getProperty("ea.cassandra.keyspace", "\"ElasticActors\"");
        Integer cassandraPort = (Integer)this.env.getProperty("ea.cassandra.port", Integer.class, (Object)9042);
        Set hostSet = StringUtils.commaDelimitedListToSet((String)cassandraHosts);
        String[] contactPoints = new String[hostSet.size()];
        int i = 0;
        for (String host : hostSet) {
            contactPoints[i] = host.contains(":") ? host.substring(0, host.indexOf(":")) : host;
            ++i;
        }
        PoolingOptions poolingOptions = new PoolingOptions();
        poolingOptions.setHeartbeatIntervalSeconds(60);
        poolingOptions.setConnectionsPerHost(HostDistance.LOCAL, 2, ((Integer)this.env.getProperty("ea.cassandra.maxActive", Integer.class, (Object)(Runtime.getRuntime().availableProcessors() * 3))).intValue());
        poolingOptions.setPoolTimeoutMillis(2000);
        Cluster cassandraCluster = Cluster.builder().withClusterName(cassandraClusterName).addContactPoints(contactPoints).withPort(cassandraPort.intValue()).withLoadBalancingPolicy((LoadBalancingPolicy)new RoundRobinPolicy()).withRetryPolicy((RetryPolicy)new LoggingRetryPolicy((RetryPolicy)DefaultRetryPolicy.INSTANCE)).withPoolingOptions(poolingOptions).withReconnectionPolicy((ReconnectionPolicy)new ConstantReconnectionPolicy((long)((Integer)this.env.getProperty("ea.cassandra.retryDownedHostsDelayInSeconds", Integer.class, (Object)1) * 1000))).withQueryOptions(new QueryOptions().setConsistencyLevel(ConsistencyLevel.QUORUM)).build();
        this.cassandraSession = cassandraCluster.connect(cassandraKeyspaceName);
    }

    @PreDestroy
    public void destroy() {
        this.cassandraSession.close();
        this.cassandraSession.getCluster().close();
    }

    @Bean(name={"asyncUpdateExecutor"}, destroyMethod="shutdown")
    public ThreadBoundExecutor createAsyncUpdateExecutor() {
        int workers = (Integer)this.env.getProperty("ea.asyncUpdateExecutor.workerCount", Integer.class, (Object)(Runtime.getRuntime().availableProcessors() * 3));
        int batchSize = (Integer)this.env.getProperty("ea.asyncUpdateExecutor.batchSize", Integer.class, (Object)20);
        boolean optimizedV1Batches = (Boolean)this.env.getProperty("ea.asyncUpdateExecutor.optimizedV1Batches", Boolean.TYPE, (Object)true);
        return new ThreadBoundExecutorImpl((ThreadBoundEventProcessor)new PersistentActorUpdateEventProcessor(this.cassandraSession, batchSize, optimizedV1Batches), batchSize, (ThreadFactory)new DaemonThreadFactory("UPDATE-EXECUTOR-WORKER"), workers);
    }

    @Bean(name={"persistentActorRepository"})
    public PersistentActorRepository getPersistentActorRepository(@Qualifier(value="asyncUpdateExecutor") ThreadBoundExecutor asyncUpdateExecutor) {
        Integer compressionThreshold = (Integer)this.env.getProperty("ea.persistentActorRepository.compressionThreshold", Integer.class, (Object)512);
        CompressingSerializer serializer = new CompressingSerializer((Serializer)new PersistentActorSerializer((SerializationFrameworks)this.cluster), compressionThreshold.intValue());
        DecompressingDeserializer deserializer = new DecompressingDeserializer((Deserializer)new PersistentActorDeserializer(this.actorRefFactory, this.cluster));
        return new CassandraPersistentActorRepository(this.cassandraSession, this.cluster.getClusterName(), asyncUpdateExecutor, (Serializer)serializer, (Deserializer)deserializer);
    }

    @Bean(name={"scheduledMessageRepository"})
    public ScheduledMessageRepository getScheduledMessageRepository() {
        return new CassandraScheduledMessageRepository(this.cluster.getClusterName(), this.cassandraSession, new ScheduledMessageDeserializer(new ActorRefDeserializer(this.actorRefFactory)));
    }

    @Bean(name={"actorSystemEventListenerRepository"})
    public ActorSystemEventListenerRepository getActorSystemEventListenerRepository() {
        return new CassandraActorSystemEventListenerRepository(this.cluster.getClusterName(), this.cassandraSession);
    }

    @Bean(name={"cassandraHealthCheck"})
    public CassandraHealthCheck getHealthCheck() {
        return new CassandraHealthCheck(this.cassandraSession);
    }
}

