/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.cassandra2.health;

import com.datastax.driver.core.Session;
import java.util.Collection;
import java.util.Set;
import org.elasticsoftware.elasticactors.health.HealthCheck;
import org.elasticsoftware.elasticactors.health.HealthCheckResult;
import org.springframework.beans.factory.annotation.Autowired;

public class CassandraHealthCheck
implements HealthCheck {
    private final Session cassandraSession;

    @Autowired
    public CassandraHealthCheck(Session cassandraSession) {
        this.cassandraSession = cassandraSession;
    }

    public HealthCheckResult check() {
        if (this.cassandraSession.isClosed()) {
            return HealthCheckResult.unhealthy((String)"Cassandra Session appears to be closed");
        }
        Set allHosts = this.cassandraSession.getCluster().getMetadata().getAllHosts();
        Collection connectedHosts = this.cassandraSession.getState().getConnectedHosts();
        if (allHosts.size() - connectedHosts.size() > 1) {
            return HealthCheckResult.unhealthy((String)"Not enough connected hosts to do QUORUM reads and writes");
        }
        return HealthCheckResult.healthy();
    }
}

